/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.LoggerSetting;
import java.io.IOException;
import java.util.List;

public final class RuntimeJavaAgentLogging
implements JsonSerializable<RuntimeJavaAgentLogging> {
    private List<LoggerSetting> loggerSettings;

    public List<LoggerSetting> loggerSettings() {
        return this.loggerSettings;
    }

    public RuntimeJavaAgentLogging withLoggerSettings(List<LoggerSetting> loggerSettings) {
        this.loggerSettings = loggerSettings;
        return this;
    }

    public void validate() {
        if (this.loggerSettings() != null) {
            this.loggerSettings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("loggerSettings", this.loggerSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RuntimeJavaAgentLogging fromJson(JsonReader jsonReader) throws IOException {
        return (RuntimeJavaAgentLogging)jsonReader.readObject(reader -> {
            RuntimeJavaAgentLogging deserializedRuntimeJavaAgentLogging = new RuntimeJavaAgentLogging();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("loggerSettings".equals(fieldName)) {
                    List loggerSettings;
                    deserializedRuntimeJavaAgentLogging.loggerSettings = loggerSettings = reader.readArray(reader1 -> LoggerSetting.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRuntimeJavaAgentLogging;
        });
    }
}

