/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ServiceBind
implements JsonSerializable<ServiceBind> {
    private String serviceId;
    private String name;
    private String clientType;
    private Map<String, String> customizedKeys;

    public String serviceId() {
        return this.serviceId;
    }

    public ServiceBind withServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ServiceBind withName(String name) {
        this.name = name;
        return this;
    }

    public String clientType() {
        return this.clientType;
    }

    public ServiceBind withClientType(String clientType) {
        this.clientType = clientType;
        return this;
    }

    public Map<String, String> customizedKeys() {
        return this.customizedKeys;
    }

    public ServiceBind withCustomizedKeys(Map<String, String> customizedKeys) {
        this.customizedKeys = customizedKeys;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceId", this.serviceId);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("clientType", this.clientType);
        jsonWriter.writeMapField("customizedKeys", this.customizedKeys, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ServiceBind fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceBind)jsonReader.readObject(reader -> {
            ServiceBind deserializedServiceBind = new ServiceBind();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceId".equals(fieldName)) {
                    deserializedServiceBind.serviceId = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServiceBind.name = reader.getString();
                    continue;
                }
                if ("clientType".equals(fieldName)) {
                    deserializedServiceBind.clientType = reader.getString();
                    continue;
                }
                if ("customizedKeys".equals(fieldName)) {
                    Map customizedKeys;
                    deserializedServiceBind.customizedKeys = customizedKeys = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceBind;
        });
    }
}

