/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner;
import com.azure.resourcemanager.appcontainers.models.ContainerType;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.PoolManagementType;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPoolProvisioningState;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import java.util.List;
import java.util.Map;

public interface SessionPool {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public String environmentId();

    public ContainerType containerType();

    public PoolManagementType poolManagementType();

    public Integer nodeCount();

    public ScaleConfiguration scaleConfiguration();

    public List<SessionPoolSecret> secrets();

    public DynamicPoolConfiguration dynamicPoolConfiguration();

    public CustomContainerTemplate customContainerTemplate();

    public SessionNetworkConfiguration sessionNetworkConfiguration();

    public String poolManagementEndpoint();

    public SessionPoolProvisioningState provisioningState();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public SessionPoolInner innerModel();

    public Update update();

    public SessionPool refresh();

    public SessionPool refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithSessionNetworkConfiguration {
            public Update withSessionNetworkConfiguration(SessionNetworkConfiguration var1);
        }

        public static interface WithCustomContainerTemplate {
            public Update withCustomContainerTemplate(CustomContainerTemplate var1);
        }

        public static interface WithDynamicPoolConfiguration {
            public Update withDynamicPoolConfiguration(DynamicPoolConfiguration var1);
        }

        public static interface WithSecrets {
            public Update withSecrets(List<SessionPoolSecret> var1);
        }

        public static interface WithScaleConfiguration {
            public Update withScaleConfiguration(ScaleConfiguration var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithScaleConfiguration,
    UpdateStages.WithSecrets,
    UpdateStages.WithDynamicPoolConfiguration,
    UpdateStages.WithCustomContainerTemplate,
    UpdateStages.WithSessionNetworkConfiguration {
        public SessionPool apply();

        public SessionPool apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithSessionNetworkConfiguration {
            public WithCreate withSessionNetworkConfiguration(SessionNetworkConfiguration var1);
        }

        public static interface WithCustomContainerTemplate {
            public WithCreate withCustomContainerTemplate(CustomContainerTemplate var1);
        }

        public static interface WithDynamicPoolConfiguration {
            public WithCreate withDynamicPoolConfiguration(DynamicPoolConfiguration var1);
        }

        public static interface WithSecrets {
            public WithCreate withSecrets(List<SessionPoolSecret> var1);
        }

        public static interface WithScaleConfiguration {
            public WithCreate withScaleConfiguration(ScaleConfiguration var1);
        }

        public static interface WithPoolManagementType {
            public WithCreate withPoolManagementType(PoolManagementType var1);
        }

        public static interface WithContainerType {
            public WithCreate withContainerType(ContainerType var1);
        }

        public static interface WithEnvironmentId {
            public WithCreate withEnvironmentId(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEnvironmentId,
        WithContainerType,
        WithPoolManagementType,
        WithScaleConfiguration,
        WithSecrets,
        WithDynamicPoolConfiguration,
        WithCustomContainerTemplate,
        WithSessionNetworkConfiguration {
            public SessionPool create();

            public SessionPool create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

