/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TimeoutPolicy
implements JsonSerializable<TimeoutPolicy> {
    private Integer responseTimeoutInSeconds;
    private Integer connectionTimeoutInSeconds;

    public Integer responseTimeoutInSeconds() {
        return this.responseTimeoutInSeconds;
    }

    public TimeoutPolicy withResponseTimeoutInSeconds(Integer responseTimeoutInSeconds) {
        this.responseTimeoutInSeconds = responseTimeoutInSeconds;
        return this;
    }

    public Integer connectionTimeoutInSeconds() {
        return this.connectionTimeoutInSeconds;
    }

    public TimeoutPolicy withConnectionTimeoutInSeconds(Integer connectionTimeoutInSeconds) {
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("responseTimeoutInSeconds", (Number)this.responseTimeoutInSeconds);
        jsonWriter.writeNumberField("connectionTimeoutInSeconds", (Number)this.connectionTimeoutInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static TimeoutPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (TimeoutPolicy)jsonReader.readObject(reader -> {
            TimeoutPolicy deserializedTimeoutPolicy = new TimeoutPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("responseTimeoutInSeconds".equals(fieldName)) {
                    deserializedTimeoutPolicy.responseTimeoutInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("connectionTimeoutInSeconds".equals(fieldName)) {
                    deserializedTimeoutPolicy.connectionTimeoutInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTimeoutPolicy;
        });
    }
}

