/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AvailableWorkloadProfileProperties;
import java.io.IOException;

public final class AvailableWorkloadProfileInner
extends ProxyResource {
    private String location;
    private AvailableWorkloadProfileProperties properties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    public String location() {
        return this.location;
    }

    public AvailableWorkloadProfileInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public AvailableWorkloadProfileProperties properties() {
        return this.properties;
    }

    public AvailableWorkloadProfileInner withProperties(AvailableWorkloadProfileProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static AvailableWorkloadProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return (AvailableWorkloadProfileInner)((Object)jsonReader.readObject(reader -> {
            AvailableWorkloadProfileInner deserializedAvailableWorkloadProfileInner = new AvailableWorkloadProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileInner.properties = AvailableWorkloadProfileProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAvailableWorkloadProfileInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailableWorkloadProfileInner;
        }));
    }
}

