/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.ContainerAppProvisioningState;
import com.azure.resourcemanager.appcontainers.models.Template;
import java.io.IOException;
import java.util.List;

public final class ContainerAppProperties
implements JsonSerializable<ContainerAppProperties> {
    private ContainerAppProvisioningState provisioningState;
    private String managedEnvironmentId;
    private String environmentId;
    private String workloadProfileName;
    private String latestRevisionName;
    private String latestReadyRevisionName;
    private String latestRevisionFqdn;
    private String customDomainVerificationId;
    private Configuration configuration;
    private Template template;
    private List<String> outboundIpAddresses;
    private String eventStreamEndpoint;

    public ContainerAppProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String managedEnvironmentId() {
        return this.managedEnvironmentId;
    }

    public ContainerAppProperties withManagedEnvironmentId(String managedEnvironmentId) {
        this.managedEnvironmentId = managedEnvironmentId;
        return this;
    }

    public String environmentId() {
        return this.environmentId;
    }

    public ContainerAppProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public String workloadProfileName() {
        return this.workloadProfileName;
    }

    public ContainerAppProperties withWorkloadProfileName(String workloadProfileName) {
        this.workloadProfileName = workloadProfileName;
        return this;
    }

    public String latestRevisionName() {
        return this.latestRevisionName;
    }

    public String latestReadyRevisionName() {
        return this.latestReadyRevisionName;
    }

    public String latestRevisionFqdn() {
        return this.latestRevisionFqdn;
    }

    public String customDomainVerificationId() {
        return this.customDomainVerificationId;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public ContainerAppProperties withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Template template() {
        return this.template;
    }

    public ContainerAppProperties withTemplate(Template template) {
        this.template = template;
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.template() != null) {
            this.template().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("managedEnvironmentId", this.managedEnvironmentId);
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeStringField("workloadProfileName", this.workloadProfileName);
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeJsonField("template", (JsonSerializable)this.template);
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerAppProperties)jsonReader.readObject(reader -> {
            ContainerAppProperties deserializedContainerAppProperties = new ContainerAppProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerAppProperties.provisioningState = ContainerAppProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("managedEnvironmentId".equals(fieldName)) {
                    deserializedContainerAppProperties.managedEnvironmentId = reader.getString();
                    continue;
                }
                if ("environmentId".equals(fieldName)) {
                    deserializedContainerAppProperties.environmentId = reader.getString();
                    continue;
                }
                if ("workloadProfileName".equals(fieldName)) {
                    deserializedContainerAppProperties.workloadProfileName = reader.getString();
                    continue;
                }
                if ("latestRevisionName".equals(fieldName)) {
                    deserializedContainerAppProperties.latestRevisionName = reader.getString();
                    continue;
                }
                if ("latestReadyRevisionName".equals(fieldName)) {
                    deserializedContainerAppProperties.latestReadyRevisionName = reader.getString();
                    continue;
                }
                if ("latestRevisionFqdn".equals(fieldName)) {
                    deserializedContainerAppProperties.latestRevisionFqdn = reader.getString();
                    continue;
                }
                if ("customDomainVerificationId".equals(fieldName)) {
                    deserializedContainerAppProperties.customDomainVerificationId = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedContainerAppProperties.configuration = Configuration.fromJson(reader);
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedContainerAppProperties.template = Template.fromJson(reader);
                    continue;
                }
                if ("outboundIpAddresses".equals(fieldName)) {
                    List outboundIpAddresses;
                    deserializedContainerAppProperties.outboundIpAddresses = outboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("eventStreamEndpoint".equals(fieldName)) {
                    deserializedContainerAppProperties.eventStreamEndpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppProperties;
        });
    }
}

