/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ContainerAppReplicaRunningState;
import com.azure.resourcemanager.appcontainers.models.ReplicaContainer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ReplicaProperties
implements JsonSerializable<ReplicaProperties> {
    private OffsetDateTime createdTime;
    private ContainerAppReplicaRunningState runningState;
    private String runningStateDetails;
    private List<ReplicaContainer> containers;
    private List<ReplicaContainer> initContainers;

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public ContainerAppReplicaRunningState runningState() {
        return this.runningState;
    }

    public String runningStateDetails() {
        return this.runningStateDetails;
    }

    public List<ReplicaContainer> containers() {
        return this.containers;
    }

    public ReplicaProperties withContainers(List<ReplicaContainer> containers) {
        this.containers = containers;
        return this;
    }

    public List<ReplicaContainer> initContainers() {
        return this.initContainers;
    }

    public ReplicaProperties withInitContainers(List<ReplicaContainer> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public void validate() {
        if (this.containers() != null) {
            this.containers().forEach(e -> e.validate());
        }
        if (this.initContainers() != null) {
            this.initContainers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("initContainers", this.initContainers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ReplicaProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicaProperties)jsonReader.readObject(reader -> {
            ReplicaProperties deserializedReplicaProperties = new ReplicaProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdTime".equals(fieldName)) {
                    deserializedReplicaProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("runningState".equals(fieldName)) {
                    deserializedReplicaProperties.runningState = ContainerAppReplicaRunningState.fromString(reader.getString());
                    continue;
                }
                if ("runningStateDetails".equals(fieldName)) {
                    deserializedReplicaProperties.runningStateDetails = reader.getString();
                    continue;
                }
                if ("containers".equals(fieldName)) {
                    List containers;
                    deserializedReplicaProperties.containers = containers = reader.readArray(reader1 -> ReplicaContainer.fromJson(reader1));
                    continue;
                }
                if ("initContainers".equals(fieldName)) {
                    List initContainers;
                    deserializedReplicaProperties.initContainers = initContainers = reader.readArray(reader1 -> ReplicaContainer.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicaProperties;
        });
    }
}

