/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.SourceControlProperties;
import com.azure.resourcemanager.appcontainers.models.GithubActionConfiguration;
import com.azure.resourcemanager.appcontainers.models.SourceControlOperationState;
import java.io.IOException;

public final class SourceControlInner
extends ProxyResource {
    private SourceControlProperties innerProperties;
    private SystemData systemData;
    private String id;
    private String name;
    private String type;

    private SourceControlProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public SourceControlOperationState operationState() {
        return this.innerProperties() == null ? null : this.innerProperties().operationState();
    }

    public String repoUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().repoUrl();
    }

    public SourceControlInner withRepoUrl(String repoUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withRepoUrl(repoUrl);
        return this;
    }

    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    public SourceControlInner withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    public GithubActionConfiguration githubActionConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().githubActionConfiguration();
    }

    public SourceControlInner withGithubActionConfiguration(GithubActionConfiguration githubActionConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlProperties();
        }
        this.innerProperties().withGithubActionConfiguration(githubActionConfiguration);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlInner fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlInner)((Object)jsonReader.readObject(reader -> {
            SourceControlInner deserializedSourceControlInner = new SourceControlInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSourceControlInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSourceControlInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSourceControlInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSourceControlInner.innerProperties = SourceControlProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSourceControlInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlInner;
        }));
    }
}

