/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.UnauthenticatedClientActionV2;
import java.io.IOException;
import java.util.List;

public final class GlobalValidation
implements JsonSerializable<GlobalValidation> {
    private UnauthenticatedClientActionV2 unauthenticatedClientAction;
    private String redirectToProvider;
    private List<String> excludedPaths;

    public UnauthenticatedClientActionV2 unauthenticatedClientAction() {
        return this.unauthenticatedClientAction;
    }

    public GlobalValidation withUnauthenticatedClientAction(UnauthenticatedClientActionV2 unauthenticatedClientAction) {
        this.unauthenticatedClientAction = unauthenticatedClientAction;
        return this;
    }

    public String redirectToProvider() {
        return this.redirectToProvider;
    }

    public GlobalValidation withRedirectToProvider(String redirectToProvider) {
        this.redirectToProvider = redirectToProvider;
        return this;
    }

    public List<String> excludedPaths() {
        return this.excludedPaths;
    }

    public GlobalValidation withExcludedPaths(List<String> excludedPaths) {
        this.excludedPaths = excludedPaths;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("unauthenticatedClientAction", this.unauthenticatedClientAction == null ? null : this.unauthenticatedClientAction.toString());
        jsonWriter.writeStringField("redirectToProvider", this.redirectToProvider);
        jsonWriter.writeArrayField("excludedPaths", this.excludedPaths, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GlobalValidation fromJson(JsonReader jsonReader) throws IOException {
        return (GlobalValidation)jsonReader.readObject(reader -> {
            GlobalValidation deserializedGlobalValidation = new GlobalValidation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("unauthenticatedClientAction".equals(fieldName)) {
                    deserializedGlobalValidation.unauthenticatedClientAction = UnauthenticatedClientActionV2.fromString(reader.getString());
                    continue;
                }
                if ("redirectToProvider".equals(fieldName)) {
                    deserializedGlobalValidation.redirectToProvider = reader.getString();
                    continue;
                }
                if ("excludedPaths".equals(fieldName)) {
                    List excludedPaths;
                    deserializedGlobalValidation.excludedPaths = excludedPaths = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGlobalValidation;
        });
    }
}

