/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JobConfigurationEventTriggerConfig;
import com.azure.resourcemanager.appcontainers.models.JobConfigurationManualTriggerConfig;
import com.azure.resourcemanager.appcontainers.models.JobConfigurationScheduleTriggerConfig;
import com.azure.resourcemanager.appcontainers.models.RegistryCredentials;
import com.azure.resourcemanager.appcontainers.models.Secret;
import com.azure.resourcemanager.appcontainers.models.TriggerType;
import java.io.IOException;
import java.util.List;

public final class JobConfiguration
implements JsonSerializable<JobConfiguration> {
    private List<Secret> secrets;
    private TriggerType triggerType;
    private int replicaTimeout;
    private Integer replicaRetryLimit;
    private JobConfigurationManualTriggerConfig manualTriggerConfig;
    private JobConfigurationScheduleTriggerConfig scheduleTriggerConfig;
    private JobConfigurationEventTriggerConfig eventTriggerConfig;
    private List<RegistryCredentials> registries;
    private static final ClientLogger LOGGER = new ClientLogger(JobConfiguration.class);

    public List<Secret> secrets() {
        return this.secrets;
    }

    public JobConfiguration withSecrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public TriggerType triggerType() {
        return this.triggerType;
    }

    public JobConfiguration withTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    public int replicaTimeout() {
        return this.replicaTimeout;
    }

    public JobConfiguration withReplicaTimeout(int replicaTimeout) {
        this.replicaTimeout = replicaTimeout;
        return this;
    }

    public Integer replicaRetryLimit() {
        return this.replicaRetryLimit;
    }

    public JobConfiguration withReplicaRetryLimit(Integer replicaRetryLimit) {
        this.replicaRetryLimit = replicaRetryLimit;
        return this;
    }

    public JobConfigurationManualTriggerConfig manualTriggerConfig() {
        return this.manualTriggerConfig;
    }

    public JobConfiguration withManualTriggerConfig(JobConfigurationManualTriggerConfig manualTriggerConfig) {
        this.manualTriggerConfig = manualTriggerConfig;
        return this;
    }

    public JobConfigurationScheduleTriggerConfig scheduleTriggerConfig() {
        return this.scheduleTriggerConfig;
    }

    public JobConfiguration withScheduleTriggerConfig(JobConfigurationScheduleTriggerConfig scheduleTriggerConfig) {
        this.scheduleTriggerConfig = scheduleTriggerConfig;
        return this;
    }

    public JobConfigurationEventTriggerConfig eventTriggerConfig() {
        return this.eventTriggerConfig;
    }

    public JobConfiguration withEventTriggerConfig(JobConfigurationEventTriggerConfig eventTriggerConfig) {
        this.eventTriggerConfig = eventTriggerConfig;
        return this;
    }

    public List<RegistryCredentials> registries() {
        return this.registries;
    }

    public JobConfiguration withRegistries(List<RegistryCredentials> registries) {
        this.registries = registries;
        return this;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.triggerType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property triggerType in model JobConfiguration"));
        }
        if (this.manualTriggerConfig() != null) {
            this.manualTriggerConfig().validate();
        }
        if (this.scheduleTriggerConfig() != null) {
            this.scheduleTriggerConfig().validate();
        }
        if (this.eventTriggerConfig() != null) {
            this.eventTriggerConfig().validate();
        }
        if (this.registries() != null) {
            this.registries().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("triggerType", this.triggerType == null ? null : this.triggerType.toString());
        jsonWriter.writeIntField("replicaTimeout", this.replicaTimeout);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("replicaRetryLimit", (Number)this.replicaRetryLimit);
        jsonWriter.writeJsonField("manualTriggerConfig", (JsonSerializable)this.manualTriggerConfig);
        jsonWriter.writeJsonField("scheduleTriggerConfig", (JsonSerializable)this.scheduleTriggerConfig);
        jsonWriter.writeJsonField("eventTriggerConfig", (JsonSerializable)this.eventTriggerConfig);
        jsonWriter.writeArrayField("registries", this.registries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (JobConfiguration)jsonReader.readObject(reader -> {
            JobConfiguration deserializedJobConfiguration = new JobConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("triggerType".equals(fieldName)) {
                    deserializedJobConfiguration.triggerType = TriggerType.fromString(reader.getString());
                    continue;
                }
                if ("replicaTimeout".equals(fieldName)) {
                    deserializedJobConfiguration.replicaTimeout = reader.getInt();
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedJobConfiguration.secrets = secrets = reader.readArray(reader1 -> Secret.fromJson(reader1));
                    continue;
                }
                if ("replicaRetryLimit".equals(fieldName)) {
                    deserializedJobConfiguration.replicaRetryLimit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("manualTriggerConfig".equals(fieldName)) {
                    deserializedJobConfiguration.manualTriggerConfig = JobConfigurationManualTriggerConfig.fromJson(reader);
                    continue;
                }
                if ("scheduleTriggerConfig".equals(fieldName)) {
                    deserializedJobConfiguration.scheduleTriggerConfig = JobConfigurationScheduleTriggerConfig.fromJson(reader);
                    continue;
                }
                if ("eventTriggerConfig".equals(fieldName)) {
                    deserializedJobConfiguration.eventTriggerConfig = JobConfigurationEventTriggerConfig.fromJson(reader);
                    continue;
                }
                if ("registries".equals(fieldName)) {
                    List registries;
                    deserializedJobConfiguration.registries = registries = reader.readArray(reader1 -> RegistryCredentials.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobConfiguration;
        });
    }
}

