/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.fluent.ContainerAppsApiClient;
import com.azure.resourcemanager.appcontainers.implementation.AvailableWorkloadProfilesImpl;
import com.azure.resourcemanager.appcontainers.implementation.BillingMetersImpl;
import com.azure.resourcemanager.appcontainers.implementation.CertificatesImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentsCertificatesImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentsDaprComponentsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ConnectedEnvironmentsStoragesImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientBuilder;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsAuthConfigsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsDiagnosticsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsRevisionReplicasImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsRevisionsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsSessionPoolsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsSourceControlsImpl;
import com.azure.resourcemanager.appcontainers.implementation.DaprComponentsImpl;
import com.azure.resourcemanager.appcontainers.implementation.JavaComponentsImpl;
import com.azure.resourcemanager.appcontainers.implementation.JobsExecutionsImpl;
import com.azure.resourcemanager.appcontainers.implementation.JobsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedCertificatesImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentDiagnosticsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentUsagesImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentsDiagnosticsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ManagedEnvironmentsStoragesImpl;
import com.azure.resourcemanager.appcontainers.implementation.NamespacesImpl;
import com.azure.resourcemanager.appcontainers.implementation.OperationsImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceProvidersImpl;
import com.azure.resourcemanager.appcontainers.implementation.UsagesImpl;
import com.azure.resourcemanager.appcontainers.models.AvailableWorkloadProfiles;
import com.azure.resourcemanager.appcontainers.models.BillingMeters;
import com.azure.resourcemanager.appcontainers.models.Certificates;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironments;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentsCertificates;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentsDaprComponents;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentsStorages;
import com.azure.resourcemanager.appcontainers.models.ContainerApps;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsAuthConfigs;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsDiagnostics;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsRevisionReplicas;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsRevisions;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsSessionPools;
import com.azure.resourcemanager.appcontainers.models.ContainerAppsSourceControls;
import com.azure.resourcemanager.appcontainers.models.DaprComponents;
import com.azure.resourcemanager.appcontainers.models.JavaComponents;
import com.azure.resourcemanager.appcontainers.models.Jobs;
import com.azure.resourcemanager.appcontainers.models.JobsExecutions;
import com.azure.resourcemanager.appcontainers.models.ManagedCertificates;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentDiagnostics;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentUsages;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironments;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentsDiagnostics;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentsStorages;
import com.azure.resourcemanager.appcontainers.models.Namespaces;
import com.azure.resourcemanager.appcontainers.models.Operations;
import com.azure.resourcemanager.appcontainers.models.ResourceProviders;
import com.azure.resourcemanager.appcontainers.models.Usages;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ContainerAppsApiManager {
    private ContainerAppsAuthConfigs containerAppsAuthConfigs;
    private AvailableWorkloadProfiles availableWorkloadProfiles;
    private BillingMeters billingMeters;
    private ConnectedEnvironments connectedEnvironments;
    private ConnectedEnvironmentsCertificates connectedEnvironmentsCertificates;
    private ConnectedEnvironmentsDaprComponents connectedEnvironmentsDaprComponents;
    private ConnectedEnvironmentsStorages connectedEnvironmentsStorages;
    private ContainerApps containerApps;
    private ContainerAppsRevisions containerAppsRevisions;
    private ContainerAppsRevisionReplicas containerAppsRevisionReplicas;
    private ContainerAppsDiagnostics containerAppsDiagnostics;
    private ManagedEnvironmentDiagnostics managedEnvironmentDiagnostics;
    private ManagedEnvironmentsDiagnostics managedEnvironmentsDiagnostics;
    private Jobs jobs;
    private Operations operations;
    private JavaComponents javaComponents;
    private JobsExecutions jobsExecutions;
    private ResourceProviders resourceProviders;
    private ManagedEnvironments managedEnvironments;
    private Certificates certificates;
    private ManagedCertificates managedCertificates;
    private Namespaces namespaces;
    private DaprComponents daprComponents;
    private ManagedEnvironmentsStorages managedEnvironmentsStorages;
    private ContainerAppsSessionPools containerAppsSessionPools;
    private ContainerAppsSourceControls containerAppsSourceControls;
    private Usages usages;
    private ManagedEnvironmentUsages managedEnvironmentUsages;
    private final ContainerAppsApiClient clientObject;

    private ContainerAppsApiManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new ContainerAppsApiClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static ContainerAppsApiManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return ContainerAppsApiManager.configure().authenticate(credential, profile);
    }

    public static ContainerAppsApiManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new ContainerAppsApiManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public ContainerAppsAuthConfigs containerAppsAuthConfigs() {
        if (this.containerAppsAuthConfigs == null) {
            this.containerAppsAuthConfigs = new ContainerAppsAuthConfigsImpl(this.clientObject.getContainerAppsAuthConfigs(), this);
        }
        return this.containerAppsAuthConfigs;
    }

    public AvailableWorkloadProfiles availableWorkloadProfiles() {
        if (this.availableWorkloadProfiles == null) {
            this.availableWorkloadProfiles = new AvailableWorkloadProfilesImpl(this.clientObject.getAvailableWorkloadProfiles(), this);
        }
        return this.availableWorkloadProfiles;
    }

    public BillingMeters billingMeters() {
        if (this.billingMeters == null) {
            this.billingMeters = new BillingMetersImpl(this.clientObject.getBillingMeters(), this);
        }
        return this.billingMeters;
    }

    public ConnectedEnvironments connectedEnvironments() {
        if (this.connectedEnvironments == null) {
            this.connectedEnvironments = new ConnectedEnvironmentsImpl(this.clientObject.getConnectedEnvironments(), this);
        }
        return this.connectedEnvironments;
    }

    public ConnectedEnvironmentsCertificates connectedEnvironmentsCertificates() {
        if (this.connectedEnvironmentsCertificates == null) {
            this.connectedEnvironmentsCertificates = new ConnectedEnvironmentsCertificatesImpl(this.clientObject.getConnectedEnvironmentsCertificates(), this);
        }
        return this.connectedEnvironmentsCertificates;
    }

    public ConnectedEnvironmentsDaprComponents connectedEnvironmentsDaprComponents() {
        if (this.connectedEnvironmentsDaprComponents == null) {
            this.connectedEnvironmentsDaprComponents = new ConnectedEnvironmentsDaprComponentsImpl(this.clientObject.getConnectedEnvironmentsDaprComponents(), this);
        }
        return this.connectedEnvironmentsDaprComponents;
    }

    public ConnectedEnvironmentsStorages connectedEnvironmentsStorages() {
        if (this.connectedEnvironmentsStorages == null) {
            this.connectedEnvironmentsStorages = new ConnectedEnvironmentsStoragesImpl(this.clientObject.getConnectedEnvironmentsStorages(), this);
        }
        return this.connectedEnvironmentsStorages;
    }

    public ContainerApps containerApps() {
        if (this.containerApps == null) {
            this.containerApps = new ContainerAppsImpl(this.clientObject.getContainerApps(), this);
        }
        return this.containerApps;
    }

    public ContainerAppsRevisions containerAppsRevisions() {
        if (this.containerAppsRevisions == null) {
            this.containerAppsRevisions = new ContainerAppsRevisionsImpl(this.clientObject.getContainerAppsRevisions(), this);
        }
        return this.containerAppsRevisions;
    }

    public ContainerAppsRevisionReplicas containerAppsRevisionReplicas() {
        if (this.containerAppsRevisionReplicas == null) {
            this.containerAppsRevisionReplicas = new ContainerAppsRevisionReplicasImpl(this.clientObject.getContainerAppsRevisionReplicas(), this);
        }
        return this.containerAppsRevisionReplicas;
    }

    public ContainerAppsDiagnostics containerAppsDiagnostics() {
        if (this.containerAppsDiagnostics == null) {
            this.containerAppsDiagnostics = new ContainerAppsDiagnosticsImpl(this.clientObject.getContainerAppsDiagnostics(), this);
        }
        return this.containerAppsDiagnostics;
    }

    public ManagedEnvironmentDiagnostics managedEnvironmentDiagnostics() {
        if (this.managedEnvironmentDiagnostics == null) {
            this.managedEnvironmentDiagnostics = new ManagedEnvironmentDiagnosticsImpl(this.clientObject.getManagedEnvironmentDiagnostics(), this);
        }
        return this.managedEnvironmentDiagnostics;
    }

    public ManagedEnvironmentsDiagnostics managedEnvironmentsDiagnostics() {
        if (this.managedEnvironmentsDiagnostics == null) {
            this.managedEnvironmentsDiagnostics = new ManagedEnvironmentsDiagnosticsImpl(this.clientObject.getManagedEnvironmentsDiagnostics(), this);
        }
        return this.managedEnvironmentsDiagnostics;
    }

    public Jobs jobs() {
        if (this.jobs == null) {
            this.jobs = new JobsImpl(this.clientObject.getJobs(), this);
        }
        return this.jobs;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public JavaComponents javaComponents() {
        if (this.javaComponents == null) {
            this.javaComponents = new JavaComponentsImpl(this.clientObject.getJavaComponents(), this);
        }
        return this.javaComponents;
    }

    public JobsExecutions jobsExecutions() {
        if (this.jobsExecutions == null) {
            this.jobsExecutions = new JobsExecutionsImpl(this.clientObject.getJobsExecutions(), this);
        }
        return this.jobsExecutions;
    }

    public ResourceProviders resourceProviders() {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ResourceProvidersImpl(this.clientObject.getResourceProviders(), this);
        }
        return this.resourceProviders;
    }

    public ManagedEnvironments managedEnvironments() {
        if (this.managedEnvironments == null) {
            this.managedEnvironments = new ManagedEnvironmentsImpl(this.clientObject.getManagedEnvironments(), this);
        }
        return this.managedEnvironments;
    }

    public Certificates certificates() {
        if (this.certificates == null) {
            this.certificates = new CertificatesImpl(this.clientObject.getCertificates(), this);
        }
        return this.certificates;
    }

    public ManagedCertificates managedCertificates() {
        if (this.managedCertificates == null) {
            this.managedCertificates = new ManagedCertificatesImpl(this.clientObject.getManagedCertificates(), this);
        }
        return this.managedCertificates;
    }

    public Namespaces namespaces() {
        if (this.namespaces == null) {
            this.namespaces = new NamespacesImpl(this.clientObject.getNamespaces(), this);
        }
        return this.namespaces;
    }

    public DaprComponents daprComponents() {
        if (this.daprComponents == null) {
            this.daprComponents = new DaprComponentsImpl(this.clientObject.getDaprComponents(), this);
        }
        return this.daprComponents;
    }

    public ManagedEnvironmentsStorages managedEnvironmentsStorages() {
        if (this.managedEnvironmentsStorages == null) {
            this.managedEnvironmentsStorages = new ManagedEnvironmentsStoragesImpl(this.clientObject.getManagedEnvironmentsStorages(), this);
        }
        return this.managedEnvironmentsStorages;
    }

    public ContainerAppsSessionPools containerAppsSessionPools() {
        if (this.containerAppsSessionPools == null) {
            this.containerAppsSessionPools = new ContainerAppsSessionPoolsImpl(this.clientObject.getContainerAppsSessionPools(), this);
        }
        return this.containerAppsSessionPools;
    }

    public ContainerAppsSourceControls containerAppsSourceControls() {
        if (this.containerAppsSourceControls == null) {
            this.containerAppsSourceControls = new ContainerAppsSourceControlsImpl(this.clientObject.getContainerAppsSourceControls(), this);
        }
        return this.containerAppsSourceControls;
    }

    public Usages usages() {
        if (this.usages == null) {
            this.usages = new UsagesImpl(this.clientObject.getUsages(), this);
        }
        return this.usages;
    }

    public ManagedEnvironmentUsages managedEnvironmentUsages() {
        if (this.managedEnvironmentUsages == null) {
            this.managedEnvironmentUsages = new ManagedEnvironmentUsagesImpl(this.clientObject.getManagedEnvironmentUsages(), this);
        }
        return this.managedEnvironmentUsages;
    }

    public ContainerAppsApiClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-appcontainers.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public ContainerAppsApiManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.appcontainers").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new ContainerAppsApiManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

