/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AuthPlatform;
import com.azure.resourcemanager.appcontainers.models.EncryptionSettings;
import com.azure.resourcemanager.appcontainers.models.GlobalValidation;
import com.azure.resourcemanager.appcontainers.models.HttpSettings;
import com.azure.resourcemanager.appcontainers.models.IdentityProviders;
import com.azure.resourcemanager.appcontainers.models.Login;
import java.io.IOException;

public final class AuthConfigProperties
implements JsonSerializable<AuthConfigProperties> {
    private AuthPlatform platform;
    private GlobalValidation globalValidation;
    private IdentityProviders identityProviders;
    private Login login;
    private HttpSettings httpSettings;
    private EncryptionSettings encryptionSettings;

    public AuthPlatform platform() {
        return this.platform;
    }

    public AuthConfigProperties withPlatform(AuthPlatform platform) {
        this.platform = platform;
        return this;
    }

    public GlobalValidation globalValidation() {
        return this.globalValidation;
    }

    public AuthConfigProperties withGlobalValidation(GlobalValidation globalValidation) {
        this.globalValidation = globalValidation;
        return this;
    }

    public IdentityProviders identityProviders() {
        return this.identityProviders;
    }

    public AuthConfigProperties withIdentityProviders(IdentityProviders identityProviders) {
        this.identityProviders = identityProviders;
        return this;
    }

    public Login login() {
        return this.login;
    }

    public AuthConfigProperties withLogin(Login login) {
        this.login = login;
        return this;
    }

    public HttpSettings httpSettings() {
        return this.httpSettings;
    }

    public AuthConfigProperties withHttpSettings(HttpSettings httpSettings) {
        this.httpSettings = httpSettings;
        return this;
    }

    public EncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public AuthConfigProperties withEncryptionSettings(EncryptionSettings encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public void validate() {
        if (this.platform() != null) {
            this.platform().validate();
        }
        if (this.globalValidation() != null) {
            this.globalValidation().validate();
        }
        if (this.identityProviders() != null) {
            this.identityProviders().validate();
        }
        if (this.login() != null) {
            this.login().validate();
        }
        if (this.httpSettings() != null) {
            this.httpSettings().validate();
        }
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("platform", (JsonSerializable)this.platform);
        jsonWriter.writeJsonField("globalValidation", (JsonSerializable)this.globalValidation);
        jsonWriter.writeJsonField("identityProviders", (JsonSerializable)this.identityProviders);
        jsonWriter.writeJsonField("login", (JsonSerializable)this.login);
        jsonWriter.writeJsonField("httpSettings", (JsonSerializable)this.httpSettings);
        jsonWriter.writeJsonField("encryptionSettings", (JsonSerializable)this.encryptionSettings);
        return jsonWriter.writeEndObject();
    }

    public static AuthConfigProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AuthConfigProperties)jsonReader.readObject(reader -> {
            AuthConfigProperties deserializedAuthConfigProperties = new AuthConfigProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("platform".equals(fieldName)) {
                    deserializedAuthConfigProperties.platform = AuthPlatform.fromJson(reader);
                    continue;
                }
                if ("globalValidation".equals(fieldName)) {
                    deserializedAuthConfigProperties.globalValidation = GlobalValidation.fromJson(reader);
                    continue;
                }
                if ("identityProviders".equals(fieldName)) {
                    deserializedAuthConfigProperties.identityProviders = IdentityProviders.fromJson(reader);
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedAuthConfigProperties.login = Login.fromJson(reader);
                    continue;
                }
                if ("httpSettings".equals(fieldName)) {
                    deserializedAuthConfigProperties.httpSettings = HttpSettings.fromJson(reader);
                    continue;
                }
                if ("encryptionSettings".equals(fieldName)) {
                    deserializedAuthConfigProperties.encryptionSettings = EncryptionSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthConfigProperties;
        });
    }
}

