/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import java.io.IOException;
import java.util.List;

public final class SessionPoolUpdatablePropertiesProperties
implements JsonSerializable<SessionPoolUpdatablePropertiesProperties> {
    private ScaleConfiguration scaleConfiguration;
    private List<SessionPoolSecret> secrets;
    private DynamicPoolConfiguration dynamicPoolConfiguration;
    private CustomContainerTemplate customContainerTemplate;
    private SessionNetworkConfiguration sessionNetworkConfiguration;

    public ScaleConfiguration scaleConfiguration() {
        return this.scaleConfiguration;
    }

    public SessionPoolUpdatablePropertiesProperties withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        this.scaleConfiguration = scaleConfiguration;
        return this;
    }

    public List<SessionPoolSecret> secrets() {
        return this.secrets;
    }

    public SessionPoolUpdatablePropertiesProperties withSecrets(List<SessionPoolSecret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.dynamicPoolConfiguration;
    }

    public SessionPoolUpdatablePropertiesProperties withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        this.dynamicPoolConfiguration = dynamicPoolConfiguration;
        return this;
    }

    public CustomContainerTemplate customContainerTemplate() {
        return this.customContainerTemplate;
    }

    public SessionPoolUpdatablePropertiesProperties withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        this.customContainerTemplate = customContainerTemplate;
        return this;
    }

    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.sessionNetworkConfiguration;
    }

    public SessionPoolUpdatablePropertiesProperties withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        this.sessionNetworkConfiguration = sessionNetworkConfiguration;
        return this;
    }

    public void validate() {
        if (this.scaleConfiguration() != null) {
            this.scaleConfiguration().validate();
        }
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.dynamicPoolConfiguration() != null) {
            this.dynamicPoolConfiguration().validate();
        }
        if (this.customContainerTemplate() != null) {
            this.customContainerTemplate().validate();
        }
        if (this.sessionNetworkConfiguration() != null) {
            this.sessionNetworkConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scaleConfiguration", (JsonSerializable)this.scaleConfiguration);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dynamicPoolConfiguration", (JsonSerializable)this.dynamicPoolConfiguration);
        jsonWriter.writeJsonField("customContainerTemplate", (JsonSerializable)this.customContainerTemplate);
        jsonWriter.writeJsonField("sessionNetworkConfiguration", (JsonSerializable)this.sessionNetworkConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static SessionPoolUpdatablePropertiesProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SessionPoolUpdatablePropertiesProperties)jsonReader.readObject(reader -> {
            SessionPoolUpdatablePropertiesProperties deserializedSessionPoolUpdatablePropertiesProperties = new SessionPoolUpdatablePropertiesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scaleConfiguration".equals(fieldName)) {
                    deserializedSessionPoolUpdatablePropertiesProperties.scaleConfiguration = ScaleConfiguration.fromJson(reader);
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedSessionPoolUpdatablePropertiesProperties.secrets = secrets = reader.readArray(reader1 -> SessionPoolSecret.fromJson(reader1));
                    continue;
                }
                if ("dynamicPoolConfiguration".equals(fieldName)) {
                    deserializedSessionPoolUpdatablePropertiesProperties.dynamicPoolConfiguration = DynamicPoolConfiguration.fromJson(reader);
                    continue;
                }
                if ("customContainerTemplate".equals(fieldName)) {
                    deserializedSessionPoolUpdatablePropertiesProperties.customContainerTemplate = CustomContainerTemplate.fromJson(reader);
                    continue;
                }
                if ("sessionNetworkConfiguration".equals(fieldName)) {
                    deserializedSessionPoolUpdatablePropertiesProperties.sessionNetworkConfiguration = SessionNetworkConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSessionPoolUpdatablePropertiesProperties;
        });
    }
}

