/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsStoragesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentStorageInner;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentStoragesCollectionInner;
import com.azure.resourcemanager.appcontainers.implementation.ContainerAppsApiClientImpl;
import com.azure.resourcemanager.appcontainers.models.DefaultErrorResponseErrorException;
import reactor.core.publisher.Mono;

public final class ConnectedEnvironmentsStoragesClientImpl
implements ConnectedEnvironmentsStoragesClient {
    private final ConnectedEnvironmentsStoragesService service;
    private final ContainerAppsApiClientImpl client;

    ConnectedEnvironmentsStoragesClientImpl(ContainerAppsApiClientImpl client) {
        this.service = (ConnectedEnvironmentsStoragesService)RestProxy.create(ConnectedEnvironmentsStoragesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentStoragesCollectionInner>> listWithResponseAsync(String resourceGroupName, String connectedEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentStoragesCollectionInner>> listWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedEnvironmentStoragesCollectionInner> listAsync(String resourceGroupName, String connectedEnvironmentName) {
        return this.listWithResponseAsync(resourceGroupName, connectedEnvironmentName).flatMap(res -> Mono.justOrEmpty((Object)((ConnectedEnvironmentStoragesCollectionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectedEnvironmentStoragesCollectionInner> listWithResponse(String resourceGroupName, String connectedEnvironmentName, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, connectedEnvironmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentStoragesCollectionInner list(String resourceGroupName, String connectedEnvironmentName) {
        return (ConnectedEnvironmentStoragesCollectionInner)this.listWithResponse(resourceGroupName, connectedEnvironmentName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentStorageInner>> getWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentStorageInner>> getWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedEnvironmentStorageInner> getAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        return this.getWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConnectedEnvironmentStorageInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectedEnvironmentStorageInner> getWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentStorageInner get(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        return (ConnectedEnvironmentStorageInner)((Object)this.getWithResponse(resourceGroupName, connectedEnvironmentName, storageName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentStorageInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        if (storageEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageEnvelope is required and cannot be null."));
        }
        storageEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), storageEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectedEnvironmentStorageInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        if (storageEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageEnvelope is required and cannot be null."));
        }
        storageEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), storageEnvelope, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConnectedEnvironmentStorageInner> createOrUpdateAsync(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ConnectedEnvironmentStorageInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectedEnvironmentStorageInner> createOrUpdateWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectedEnvironmentStorageInner createOrUpdate(String resourceGroupName, String connectedEnvironmentName, String storageName, ConnectedEnvironmentStorageInner storageEnvelope) {
        return (ConnectedEnvironmentStorageInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, connectedEnvironmentName, storageName, storageEnvelope, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (connectedEnvironmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectedEnvironmentName is required and cannot be null."));
        }
        if (storageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter storageName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, connectedEnvironmentName, storageName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        return this.deleteWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String connectedEnvironmentName, String storageName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, connectedEnvironmentName, storageName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String connectedEnvironmentName, String storageName) {
        this.deleteWithResponse(resourceGroupName, connectedEnvironmentName, storageName, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerAppsApiClie")
    public static interface ConnectedEnvironmentsStoragesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ConnectedEnvironmentStoragesCollectionInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ConnectedEnvironmentStorageInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<ConnectedEnvironmentStorageInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ConnectedEnvironmentStorageInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/connectedEnvironments/{connectedEnvironmentName}/storages/{storageName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=DefaultErrorResponseErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="connectedEnvironmentName") String var4, @PathParam(value="storageName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

