/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DiagnosticDataProviderMetadata;
import com.azure.resourcemanager.appcontainers.models.DiagnosticsDataApiResponse;
import com.azure.resourcemanager.appcontainers.models.DiagnosticsDefinition;
import com.azure.resourcemanager.appcontainers.models.DiagnosticsStatus;
import java.io.IOException;
import java.util.List;

public final class DiagnosticsProperties
implements JsonSerializable<DiagnosticsProperties> {
    private DiagnosticsDefinition metadata;
    private List<DiagnosticsDataApiResponse> dataset;
    private DiagnosticsStatus status;
    private DiagnosticDataProviderMetadata dataProviderMetadata;

    public DiagnosticsDefinition metadata() {
        return this.metadata;
    }

    public DiagnosticsProperties withMetadata(DiagnosticsDefinition metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<DiagnosticsDataApiResponse> dataset() {
        return this.dataset;
    }

    public DiagnosticsProperties withDataset(List<DiagnosticsDataApiResponse> dataset) {
        this.dataset = dataset;
        return this;
    }

    public DiagnosticsStatus status() {
        return this.status;
    }

    public DiagnosticsProperties withStatus(DiagnosticsStatus status) {
        this.status = status;
        return this;
    }

    public DiagnosticDataProviderMetadata dataProviderMetadata() {
        return this.dataProviderMetadata;
    }

    public DiagnosticsProperties withDataProviderMetadata(DiagnosticDataProviderMetadata dataProviderMetadata) {
        this.dataProviderMetadata = dataProviderMetadata;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().validate();
        }
        if (this.dataset() != null) {
            this.dataset().forEach(e -> e.validate());
        }
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.dataProviderMetadata() != null) {
            this.dataProviderMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("metadata", (JsonSerializable)this.metadata);
        jsonWriter.writeArrayField("dataset", this.dataset, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("status", (JsonSerializable)this.status);
        jsonWriter.writeJsonField("dataProviderMetadata", (JsonSerializable)this.dataProviderMetadata);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticsProperties)jsonReader.readObject(reader -> {
            DiagnosticsProperties deserializedDiagnosticsProperties = new DiagnosticsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("metadata".equals(fieldName)) {
                    deserializedDiagnosticsProperties.metadata = DiagnosticsDefinition.fromJson(reader);
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    List dataset;
                    deserializedDiagnosticsProperties.dataset = dataset = reader.readArray(reader1 -> DiagnosticsDataApiResponse.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDiagnosticsProperties.status = DiagnosticsStatus.fromJson(reader);
                    continue;
                }
                if ("dataProviderMetadata".equals(fieldName)) {
                    deserializedDiagnosticsProperties.dataProviderMetadata = DiagnosticDataProviderMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticsProperties;
        });
    }
}

