/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.models.WebTestGeolocation;
import com.azure.resourcemanager.applicationinsights.models.WebTestKind;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesConfiguration;
import com.azure.resourcemanager.applicationinsights.models.WebtestsResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class WebTestInner
extends WebtestsResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WebTestInner.class);
    @JsonProperty(value="kind")
    private WebTestKind kind;
    @JsonProperty(value="properties.SyntheticMonitorId")
    private String syntheticMonitorId;
    @JsonProperty(value="properties.Name")
    private String webTestName;
    @JsonProperty(value="properties.Description")
    private String description;
    @JsonProperty(value="properties.Enabled")
    private Boolean enabled;
    @JsonProperty(value="properties.Frequency")
    private Integer frequency;
    @JsonProperty(value="properties.Timeout")
    private Integer timeout;
    @JsonProperty(value="properties.Kind")
    private WebTestKind webTestKind;
    @JsonProperty(value="properties.RetryEnabled")
    private Boolean retryEnabled;
    @JsonProperty(value="properties.Locations")
    private List<WebTestGeolocation> locations;
    @JsonProperty(value="properties.Configuration")
    private WebTestPropertiesConfiguration configuration;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    public WebTestKind kind() {
        return this.kind;
    }

    public WebTestInner withKind(WebTestKind kind) {
        this.kind = kind;
        return this;
    }

    public String syntheticMonitorId() {
        return this.syntheticMonitorId;
    }

    public WebTestInner withSyntheticMonitorId(String syntheticMonitorId) {
        this.syntheticMonitorId = syntheticMonitorId;
        return this;
    }

    public String webTestName() {
        return this.webTestName;
    }

    public WebTestInner withWebTestName(String webTestName) {
        this.webTestName = webTestName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public WebTestInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public WebTestInner withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer frequency() {
        return this.frequency;
    }

    public WebTestInner withFrequency(Integer frequency) {
        this.frequency = frequency;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public WebTestInner withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public WebTestKind webTestKind() {
        return this.webTestKind;
    }

    public WebTestInner withWebTestKind(WebTestKind webTestKind) {
        this.webTestKind = webTestKind;
        return this;
    }

    public Boolean retryEnabled() {
        return this.retryEnabled;
    }

    public WebTestInner withRetryEnabled(Boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
        return this;
    }

    public List<WebTestGeolocation> locations() {
        return this.locations;
    }

    public WebTestInner withLocations(List<WebTestGeolocation> locations) {
        this.locations = locations;
        return this;
    }

    public WebTestPropertiesConfiguration configuration() {
        return this.configuration;
    }

    public WebTestInner withConfiguration(WebTestPropertiesConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    @Override
    public WebTestInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public WebTestInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
        if (this.configuration() != null) {
            this.configuration().validate();
        }
    }
}

