/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.applicationinsights.fluent.AnalyticsItemsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentAnalyticsItemInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientImpl;
import com.azure.resourcemanager.applicationinsights.models.ItemScope;
import com.azure.resourcemanager.applicationinsights.models.ItemScopePath;
import com.azure.resourcemanager.applicationinsights.models.ItemTypeParameter;
import java.util.List;
import reactor.core.publisher.Mono;

public final class AnalyticsItemsClientImpl
implements AnalyticsItemsClient {
    private final ClientLogger logger = new ClientLogger(AnalyticsItemsClientImpl.class);
    private final AnalyticsItemsService service;
    private final ApplicationInsightsManagementClientImpl client;

    AnalyticsItemsClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service = (AnalyticsItemsService)RestProxy.create(AnalyticsItemsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<Response<List<ApplicationInsightsComponentAnalyticsItemInner>>> listWithResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, scopePath, "2015-05-01", scope, type, includeContent, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<List<ApplicationInsightsComponentAnalyticsItemInner>>> listWithResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, scopePath, "2015-05-01", scope, type, includeContent, "application/json", context);
    }

    private Mono<List<ApplicationInsightsComponentAnalyticsItemInner>> listAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent) {
        return this.listWithResponseAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    private Mono<List<ApplicationInsightsComponentAnalyticsItemInner>> listAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        ItemScope scope = null;
        ItemTypeParameter type = null;
        Boolean includeContent = null;
        return this.listWithResponseAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<ApplicationInsightsComponentAnalyticsItemInner> list(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        ItemScope scope = null;
        ItemTypeParameter type = null;
        Boolean includeContent = null;
        return (List)this.listAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent).block();
    }

    @Override
    public Response<List<ApplicationInsightsComponentAnalyticsItemInner>> listWithResponse(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent, context).block();
    }

    private Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> getWithResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, scopePath, "2015-05-01", id, name, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> getWithResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, scopePath, "2015-05-01", id, name, "application/json", context);
    }

    private Mono<ApplicationInsightsComponentAnalyticsItemInner> getAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentAnalyticsItemInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    private Mono<ApplicationInsightsComponentAnalyticsItemInner> getAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        String id = null;
        String name = null;
        return this.getWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentAnalyticsItemInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInsightsComponentAnalyticsItemInner get(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        String id = null;
        String name = null;
        return (ApplicationInsightsComponentAnalyticsItemInner)this.getAsync(resourceGroupName, resourceName, scopePath, id, name).block();
    }

    @Override
    public Response<ApplicationInsightsComponentAnalyticsItemInner> getWithResponse(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name, context).block();
    }

    private Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> putWithResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        if (itemProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter itemProperties is required and cannot be null."));
        }
        itemProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, scopePath, "2015-05-01", overrideItem, itemProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> putWithResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        if (itemProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter itemProperties is required and cannot be null."));
        }
        itemProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.put(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, scopePath, "2015-05-01", overrideItem, itemProperties, "application/json", context);
    }

    private Mono<ApplicationInsightsComponentAnalyticsItemInner> putAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem) {
        return this.putWithResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentAnalyticsItemInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    private Mono<ApplicationInsightsComponentAnalyticsItemInner> putAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties) {
        Boolean overrideItem = null;
        return this.putWithResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentAnalyticsItemInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInsightsComponentAnalyticsItemInner put(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties) {
        Boolean overrideItem = null;
        return (ApplicationInsightsComponentAnalyticsItemInner)this.putAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem).block();
    }

    @Override
    public Response<ApplicationInsightsComponentAnalyticsItemInner> putWithResponse(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem, Context context) {
        return (Response)this.putWithResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem, context).block();
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, scopePath, "2015-05-01", id, name, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, scopePath, "2015-05-01", id, name, context);
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name).flatMap(res -> Mono.empty());
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        String id = null;
        String name = null;
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        String id = null;
        String name = null;
        this.deleteAsync(resourceGroupName, resourceName, scopePath, id, name).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApplicationInsightsM")
    private static interface AnalyticsItemsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<ApplicationInsightsComponentAnalyticsItemInner>>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @PathParam(value="scopePath") ItemScopePath var5, @QueryParam(value="api-version") String var6, @QueryParam(value="scope") ItemScope var7, @QueryParam(value="type") ItemTypeParameter var8, @QueryParam(value="includeContent") Boolean var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @PathParam(value="scopePath") ItemScopePath var5, @QueryParam(value="api-version") String var6, @QueryParam(value="id") String var7, @QueryParam(value="name") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> put(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @PathParam(value="scopePath") ItemScopePath var5, @QueryParam(value="api-version") String var6, @QueryParam(value="overrideItem") Boolean var7, @BodyParam(value="application/json") ApplicationInsightsComponentAnalyticsItemInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @PathParam(value="scopePath") ItemScopePath var5, @QueryParam(value="api-version") String var6, @QueryParam(value="id") String var7, @QueryParam(value="name") String var8, Context var9);
    }
}

