/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.AnalyticsItemsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentAnalyticsItemInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsComponentAnalyticsItemImpl;
import com.azure.resourcemanager.applicationinsights.models.AnalyticsItems;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentAnalyticsItem;
import com.azure.resourcemanager.applicationinsights.models.ItemScope;
import com.azure.resourcemanager.applicationinsights.models.ItemScopePath;
import com.azure.resourcemanager.applicationinsights.models.ItemTypeParameter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class AnalyticsItemsImpl
implements AnalyticsItems {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AnalyticsItemsImpl.class);
    private final AnalyticsItemsClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public AnalyticsItemsImpl(AnalyticsItemsClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public List<ApplicationInsightsComponentAnalyticsItem> list(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        List<ApplicationInsightsComponentAnalyticsItemInner> inner = this.serviceClient().list(resourceGroupName, resourceName, scopePath);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new ApplicationInsightsComponentAnalyticsItemImpl((ApplicationInsightsComponentAnalyticsItemInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Response<List<ApplicationInsightsComponentAnalyticsItem>> listWithResponse(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent, Context context) {
        Response<List<ApplicationInsightsComponentAnalyticsItemInner>> inner = this.serviceClient().listWithResponse(resourceGroupName, resourceName, scopePath, scope, type, includeContent, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), ((List)inner.getValue()).stream().map(inner1 -> new ApplicationInsightsComponentAnalyticsItemImpl((ApplicationInsightsComponentAnalyticsItemInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponentAnalyticsItem get(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        ApplicationInsightsComponentAnalyticsItemInner inner = this.serviceClient().get(resourceGroupName, resourceName, scopePath);
        if (inner != null) {
            return new ApplicationInsightsComponentAnalyticsItemImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponentAnalyticsItem> getWithResponse(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name, Context context) {
        Response<ApplicationInsightsComponentAnalyticsItemInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, scopePath, id, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentAnalyticsItemImpl((ApplicationInsightsComponentAnalyticsItemInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponentAnalyticsItem put(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties) {
        ApplicationInsightsComponentAnalyticsItemInner inner = this.serviceClient().put(resourceGroupName, resourceName, scopePath, itemProperties);
        if (inner != null) {
            return new ApplicationInsightsComponentAnalyticsItemImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponentAnalyticsItem> putWithResponse(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem, Context context) {
        Response<ApplicationInsightsComponentAnalyticsItemInner> inner = this.serviceClient().putWithResponse(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentAnalyticsItemImpl((ApplicationInsightsComponentAnalyticsItemInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        this.serviceClient().delete(resourceGroupName, resourceName, scopePath);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, scopePath, id, name, context);
    }

    private AnalyticsItemsClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}

