/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentFeatureCapabilitiesClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFeatureCapabilitiesInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsComponentFeatureCapabilitiesImpl;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentFeatureCapabilities;
import com.azure.resourcemanager.applicationinsights.models.ComponentFeatureCapabilities;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ComponentFeatureCapabilitiesImpl
implements ComponentFeatureCapabilities {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ComponentFeatureCapabilitiesImpl.class);
    private final ComponentFeatureCapabilitiesClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public ComponentFeatureCapabilitiesImpl(ComponentFeatureCapabilitiesClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ApplicationInsightsComponentFeatureCapabilities get(String resourceGroupName, String resourceName) {
        ApplicationInsightsComponentFeatureCapabilitiesInner inner = this.serviceClient().get(resourceGroupName, resourceName);
        if (inner != null) {
            return new ApplicationInsightsComponentFeatureCapabilitiesImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponentFeatureCapabilities> getWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<ApplicationInsightsComponentFeatureCapabilitiesInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentFeatureCapabilitiesImpl((ApplicationInsightsComponentFeatureCapabilitiesInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    private ComponentFeatureCapabilitiesClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}

