/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.applicationinsights.fluent.FavoritesClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFavoriteInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsManagementClientImpl;
import com.azure.resourcemanager.applicationinsights.models.FavoriteSourceType;
import com.azure.resourcemanager.applicationinsights.models.FavoriteType;
import java.util.List;
import reactor.core.publisher.Mono;

public final class FavoritesClientImpl
implements FavoritesClient {
    private final ClientLogger logger = new ClientLogger(FavoritesClientImpl.class);
    private final FavoritesService service;
    private final ApplicationInsightsManagementClientImpl client;

    FavoritesClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service = (FavoritesService)RestProxy.create(FavoritesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<Response<List<ApplicationInsightsComponentFavoriteInner>>> listWithResponseAsync(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        String tagsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(tags, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteType, sourceType, canFetchContent, tagsConverted, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<List<ApplicationInsightsComponentFavoriteInner>>> listWithResponseAsync(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        String tagsConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(tags, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteType, sourceType, canFetchContent, tagsConverted, "application/json", context);
    }

    private Mono<List<ApplicationInsightsComponentFavoriteInner>> listAsync(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags) {
        return this.listWithResponseAsync(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    private Mono<List<ApplicationInsightsComponentFavoriteInner>> listAsync(String resourceGroupName, String resourceName) {
        FavoriteType favoriteType = null;
        FavoriteSourceType sourceType = null;
        Boolean canFetchContent = null;
        List<String> tags = null;
        return this.listWithResponseAsync(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<ApplicationInsightsComponentFavoriteInner> list(String resourceGroupName, String resourceName) {
        FavoriteType favoriteType = null;
        FavoriteSourceType sourceType = null;
        Boolean canFetchContent = null;
        List<String> tags = null;
        return (List)this.listAsync(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags).block();
    }

    @Override
    public Response<List<ApplicationInsightsComponentFavoriteInner>> listWithResponse(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags, context).block();
    }

    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String favoriteId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String favoriteId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteId, "application/json", context);
    }

    private Mono<ApplicationInsightsComponentFavoriteInner> getAsync(String resourceGroupName, String resourceName, String favoriteId) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, favoriteId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentFavoriteInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInsightsComponentFavoriteInner get(String resourceGroupName, String resourceName, String favoriteId) {
        return (ApplicationInsightsComponentFavoriteInner)this.getAsync(resourceGroupName, resourceName, favoriteId).block();
    }

    @Override
    public Response<ApplicationInsightsComponentFavoriteInner> getWithResponse(String resourceGroupName, String resourceName, String favoriteId, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, favoriteId, context).block();
    }

    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> addWithResponseAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        if (favoriteProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null."));
        }
        favoriteProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.add(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteId, favoriteProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> addWithResponseAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        if (favoriteProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null."));
        }
        favoriteProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.add(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteId, favoriteProperties, "application/json", context);
    }

    private Mono<ApplicationInsightsComponentFavoriteInner> addAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return this.addWithResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentFavoriteInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInsightsComponentFavoriteInner add(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return (ApplicationInsightsComponentFavoriteInner)this.addAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties).block();
    }

    @Override
    public Response<ApplicationInsightsComponentFavoriteInner> addWithResponse(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties, Context context) {
        return (Response)this.addWithResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties, context).block();
    }

    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> updateWithResponseAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        if (favoriteProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null."));
        }
        favoriteProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteId, favoriteProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> updateWithResponseAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        if (favoriteProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null."));
        }
        favoriteProperties.validate();
        String apiVersion = "2015-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteId, favoriteProperties, "application/json", context);
    }

    private Mono<ApplicationInsightsComponentFavoriteInner> updateAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return this.updateWithResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ApplicationInsightsComponentFavoriteInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ApplicationInsightsComponentFavoriteInner update(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return (ApplicationInsightsComponentFavoriteInner)this.updateAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties).block();
    }

    @Override
    public Response<ApplicationInsightsComponentFavoriteInner> updateWithResponse(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties, context).block();
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String favoriteId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteId, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String favoriteId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        String apiVersion = "2015-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, "2015-05-01", this.client.getSubscriptionId(), resourceName, favoriteId, context);
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String favoriteId) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, favoriteId).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String resourceGroupName, String resourceName, String favoriteId) {
        this.deleteAsync(resourceGroupName, resourceName, favoriteId).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, String favoriteId, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, favoriteId, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ApplicationInsightsM")
    private static interface FavoritesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<ApplicationInsightsComponentFavoriteInner>>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @QueryParam(value="favoriteType") FavoriteType var6, @QueryParam(value="sourceType") FavoriteSourceType var7, @QueryParam(value="canFetchContent") Boolean var8, @QueryParam(value="tags") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentFavoriteInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="favoriteId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentFavoriteInner>> add(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="favoriteId") String var6, @BodyParam(value="application/json") ApplicationInsightsComponentFavoriteInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ApplicationInsightsComponentFavoriteInner>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="favoriteId") String var6, @BodyParam(value="application/json") ApplicationInsightsComponentFavoriteInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="favoriteId") String var6, Context var7);
    }
}

