/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.models.WebTestInner;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.models.TagsResource;
import com.azure.resourcemanager.applicationinsights.models.WebTest;
import com.azure.resourcemanager.applicationinsights.models.WebTestGeolocation;
import com.azure.resourcemanager.applicationinsights.models.WebTestKind;
import com.azure.resourcemanager.applicationinsights.models.WebTestPropertiesConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class WebTestImpl
implements WebTest,
WebTest.Definition,
WebTest.Update {
    private WebTestInner innerObject;
    private final ApplicationInsightsManager serviceManager;
    private String resourceGroupName;
    private String webTestName;
    private TagsResource updateWebTestTags;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public WebTestKind kind() {
        return this.innerModel().kind();
    }

    @Override
    public String syntheticMonitorId() {
        return this.innerModel().syntheticMonitorId();
    }

    @Override
    public String webTestName() {
        return this.innerModel().webTestName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public Boolean enabled() {
        return this.innerModel().enabled();
    }

    @Override
    public Integer frequency() {
        return this.innerModel().frequency();
    }

    @Override
    public Integer timeout() {
        return this.innerModel().timeout();
    }

    @Override
    public WebTestKind webTestKind() {
        return this.innerModel().webTestKind();
    }

    @Override
    public Boolean retryEnabled() {
        return this.innerModel().retryEnabled();
    }

    @Override
    public List<WebTestGeolocation> locations() {
        List<WebTestGeolocation> inner = this.innerModel().locations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public WebTestPropertiesConfiguration configuration() {
        return this.innerModel().configuration();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public WebTestInner innerModel() {
        return this.innerObject;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public WebTestImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public WebTest create() {
        this.innerObject = (WebTestInner)((Object)this.serviceManager.serviceClient().getWebTests().createOrUpdateWithResponse(this.resourceGroupName, this.webTestName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public WebTest create(Context context) {
        this.innerObject = (WebTestInner)((Object)this.serviceManager.serviceClient().getWebTests().createOrUpdateWithResponse(this.resourceGroupName, this.webTestName, this.innerModel(), context).getValue());
        return this;
    }

    WebTestImpl(String name, ApplicationInsightsManager serviceManager) {
        this.innerObject = new WebTestInner();
        this.serviceManager = serviceManager;
        this.webTestName = name;
    }

    @Override
    public WebTestImpl update() {
        this.updateWebTestTags = new TagsResource();
        return this;
    }

    @Override
    public WebTest apply() {
        this.innerObject = (WebTestInner)((Object)this.serviceManager.serviceClient().getWebTests().updateTagsWithResponse(this.resourceGroupName, this.webTestName, this.updateWebTestTags, Context.NONE).getValue());
        return this;
    }

    @Override
    public WebTest apply(Context context) {
        this.innerObject = (WebTestInner)((Object)this.serviceManager.serviceClient().getWebTests().updateTagsWithResponse(this.resourceGroupName, this.webTestName, this.updateWebTestTags, context).getValue());
        return this;
    }

    WebTestImpl(WebTestInner innerObject, ApplicationInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.webTestName = Utils.getValueFromIdByName(innerObject.id(), "webtests");
    }

    @Override
    public WebTest refresh() {
        this.innerObject = (WebTestInner)((Object)this.serviceManager.serviceClient().getWebTests().getByResourceGroupWithResponse(this.resourceGroupName, this.webTestName, Context.NONE).getValue());
        return this;
    }

    @Override
    public WebTest refresh(Context context) {
        this.innerObject = (WebTestInner)((Object)this.serviceManager.serviceClient().getWebTests().getByResourceGroupWithResponse(this.resourceGroupName, this.webTestName, context).getValue());
        return this;
    }

    @Override
    public WebTestImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public WebTestImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public WebTestImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateWebTestTags.withTags(tags);
        return this;
    }

    @Override
    public WebTestImpl withKind(WebTestKind kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public WebTestImpl withSyntheticMonitorId(String syntheticMonitorId) {
        this.innerModel().withSyntheticMonitorId(syntheticMonitorId);
        return this;
    }

    @Override
    public WebTestImpl withWebTestName(String webTestName) {
        this.innerModel().withWebTestName(webTestName);
        return this;
    }

    @Override
    public WebTestImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public WebTestImpl withEnabled(Boolean enabled) {
        this.innerModel().withEnabled(enabled);
        return this;
    }

    @Override
    public WebTestImpl withFrequency(Integer frequency) {
        this.innerModel().withFrequency(frequency);
        return this;
    }

    @Override
    public WebTestImpl withTimeout(Integer timeout) {
        this.innerModel().withTimeout(timeout);
        return this;
    }

    @Override
    public WebTestImpl withWebTestKind(WebTestKind webTestKind) {
        this.innerModel().withWebTestKind(webTestKind);
        return this;
    }

    @Override
    public WebTestImpl withRetryEnabled(Boolean retryEnabled) {
        this.innerModel().withRetryEnabled(retryEnabled);
        return this;
    }

    @Override
    public WebTestImpl withLocations(List<WebTestGeolocation> locations) {
        this.innerModel().withLocations(locations);
        return this;
    }

    @Override
    public WebTestImpl withConfiguration(WebTestPropertiesConfiguration configuration) {
        this.innerModel().withConfiguration(configuration);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

