/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.FavoritesClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFavoriteInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsComponentFavoriteImpl;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentFavorite;
import com.azure.resourcemanager.applicationinsights.models.FavoriteSourceType;
import com.azure.resourcemanager.applicationinsights.models.FavoriteType;
import com.azure.resourcemanager.applicationinsights.models.Favorites;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class FavoritesImpl
implements Favorites {
    private static final ClientLogger LOGGER = new ClientLogger(FavoritesImpl.class);
    private final FavoritesClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public FavoritesImpl(FavoritesClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public List<ApplicationInsightsComponentFavorite> list(String resourceGroupName, String resourceName) {
        List<ApplicationInsightsComponentFavoriteInner> inner = this.serviceClient().list(resourceGroupName, resourceName);
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new ApplicationInsightsComponentFavoriteImpl((ApplicationInsightsComponentFavoriteInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public Response<List<ApplicationInsightsComponentFavorite>> listWithResponse(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags, Context context) {
        Response<List<ApplicationInsightsComponentFavoriteInner>> inner = this.serviceClient().listWithResponse(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), ((List)inner.getValue()).stream().map(inner1 -> new ApplicationInsightsComponentFavoriteImpl((ApplicationInsightsComponentFavoriteInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponentFavorite get(String resourceGroupName, String resourceName, String favoriteId) {
        ApplicationInsightsComponentFavoriteInner inner = this.serviceClient().get(resourceGroupName, resourceName, favoriteId);
        if (inner != null) {
            return new ApplicationInsightsComponentFavoriteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponentFavorite> getWithResponse(String resourceGroupName, String resourceName, String favoriteId, Context context) {
        Response<ApplicationInsightsComponentFavoriteInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, favoriteId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentFavoriteImpl((ApplicationInsightsComponentFavoriteInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponentFavorite add(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        ApplicationInsightsComponentFavoriteInner inner = this.serviceClient().add(resourceGroupName, resourceName, favoriteId, favoriteProperties);
        if (inner != null) {
            return new ApplicationInsightsComponentFavoriteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponentFavorite> addWithResponse(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties, Context context) {
        Response<ApplicationInsightsComponentFavoriteInner> inner = this.serviceClient().addWithResponse(resourceGroupName, resourceName, favoriteId, favoriteProperties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentFavoriteImpl((ApplicationInsightsComponentFavoriteInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApplicationInsightsComponentFavorite update(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        ApplicationInsightsComponentFavoriteInner inner = this.serviceClient().update(resourceGroupName, resourceName, favoriteId, favoriteProperties);
        if (inner != null) {
            return new ApplicationInsightsComponentFavoriteImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponentFavorite> updateWithResponse(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties, Context context) {
        Response<ApplicationInsightsComponentFavoriteInner> inner = this.serviceClient().updateWithResponse(resourceGroupName, resourceName, favoriteId, favoriteProperties, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentFavoriteImpl((ApplicationInsightsComponentFavoriteInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String resourceName, String favoriteId) {
        this.serviceClient().delete(resourceGroupName, resourceName, favoriteId);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, String favoriteId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, favoriteId, context);
    }

    private FavoritesClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}

