// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An Application Insights component daily data volume cap status. */
@Immutable
public final class ApplicationInsightsComponentQuotaStatusInner {
    /*
     * The Application ID for the Application Insights component.
     */
    @JsonProperty(value = "AppId", access = JsonProperty.Access.WRITE_ONLY)
    private String appId;

    /*
     * The daily data volume cap is met, and data ingestion will be stopped.
     */
    @JsonProperty(value = "ShouldBeThrottled", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean shouldBeThrottled;

    /*
     * Date and time when the daily data volume cap will be reset, and data
     * ingestion will resume.
     */
    @JsonProperty(value = "ExpirationTime", access = JsonProperty.Access.WRITE_ONLY)
    private String expirationTime;

    /**
     * Get the appId property: The Application ID for the Application Insights component.
     *
     * @return the appId value.
     */
    public String appId() {
        return this.appId;
    }

    /**
     * Get the shouldBeThrottled property: The daily data volume cap is met, and data ingestion will be stopped.
     *
     * @return the shouldBeThrottled value.
     */
    public Boolean shouldBeThrottled() {
        return this.shouldBeThrottled;
    }

    /**
     * Get the expirationTime property: Date and time when the daily data volume cap will be reset, and data ingestion
     * will resume.
     *
     * @return the expirationTime value.
     */
    public String expirationTime() {
        return this.expirationTime;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
