// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentLinkedStorageAccountsOperationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ComponentLinkedStorageAccountsInner;
import com.azure.resourcemanager.applicationinsights.models.ComponentLinkedStorageAccountsPatch;
import com.azure.resourcemanager.applicationinsights.models.StorageType;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * ComponentLinkedStorageAccountsOperationsClient.
 */
public final class ComponentLinkedStorageAccountsOperationsClientImpl
    implements ComponentLinkedStorageAccountsOperationsClient {
    /** The proxy service used to perform REST calls. */
    private final ComponentLinkedStorageAccountsOperationsService service;

    /** The service client containing this operation class. */
    private final ApplicationInsightsManagementClientImpl client;

    /**
     * Initializes an instance of ComponentLinkedStorageAccountsOperationsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ComponentLinkedStorageAccountsOperationsClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    ComponentLinkedStorageAccountsOperationsService.class,
                    client.getHttpPipeline(),
                    client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for
     * ApplicationInsightsManagementClientComponentLinkedStorageAccountsOperations to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ApplicationInsightsM")
    private interface ComponentLinkedStorageAccountsOperationsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components"
                + "/{resourceName}/linkedStorageAccounts/{storageType}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ComponentLinkedStorageAccountsInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @PathParam("storageType") StorageType storageType,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components"
                + "/{resourceName}/linkedStorageAccounts/{storageType}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ComponentLinkedStorageAccountsInner>> createAndUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @PathParam("storageType") StorageType storageType,
            @BodyParam("application/json") ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components"
                + "/{resourceName}/linkedStorageAccounts/{storageType}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ComponentLinkedStorageAccountsInner>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @PathParam("storageType") StorageType storageType,
            @BodyParam("application/json") ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components"
                + "/{resourceName}/linkedStorageAccounts/{storageType}")
        @ExpectedResponses({200, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @PathParam("storageType") StorageType storageType,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Returns the current linked storage settings for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> getWithResponseAsync(
        String resourceGroupName, String resourceName, StorageType storageType) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error(new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        final String apiVersion = "2020-03-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            storageType,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Returns the current linked storage settings for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> getWithResponseAsync(
        String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error(new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        final String apiVersion = "2020-03-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                storageType,
                accept,
                context);
    }

    /**
     * Returns the current linked storage settings for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ComponentLinkedStorageAccountsInner> getAsync(
        String resourceGroupName, String resourceName, StorageType storageType) {
        return getWithResponseAsync(resourceGroupName, resourceName, storageType)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Returns the current linked storage settings for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ComponentLinkedStorageAccountsInner get(
        String resourceGroupName, String resourceName, StorageType storageType) {
        return getAsync(resourceGroupName, resourceName, storageType).block();
    }

    /**
     * Returns the current linked storage settings for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ComponentLinkedStorageAccountsInner> getWithResponse(
        String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        return getWithResponseAsync(resourceGroupName, resourceName, storageType, context).block();
    }

    /**
     * Replace current linked storage account for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update linked storage accounts for
     *     an Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> createAndUpdateWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error(new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        if (linkedStorageAccountsProperties == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter linkedStorageAccountsProperties is required and cannot be null."));
        } else {
            linkedStorageAccountsProperties.validate();
        }
        final String apiVersion = "2020-03-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createAndUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            storageType,
                            linkedStorageAccountsProperties,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Replace current linked storage account for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update linked storage accounts for
     *     an Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> createAndUpdateWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error(new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        if (linkedStorageAccountsProperties == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter linkedStorageAccountsProperties is required and cannot be null."));
        } else {
            linkedStorageAccountsProperties.validate();
        }
        final String apiVersion = "2020-03-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createAndUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                storageType,
                linkedStorageAccountsProperties,
                accept,
                context);
    }

    /**
     * Replace current linked storage account for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update linked storage accounts for
     *     an Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ComponentLinkedStorageAccountsInner> createAndUpdateAsync(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties) {
        return createAndUpdateWithResponseAsync(
                resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Replace current linked storage account for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update linked storage accounts for
     *     an Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ComponentLinkedStorageAccountsInner createAndUpdate(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties) {
        return createAndUpdateAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties)
            .block();
    }

    /**
     * Replace current linked storage account for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update linked storage accounts for
     *     an Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ComponentLinkedStorageAccountsInner> createAndUpdateWithResponse(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsInner linkedStorageAccountsProperties,
        Context context) {
        return createAndUpdateWithResponseAsync(
                resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties, context)
            .block();
    }

    /**
     * Update linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update a linked storage accounts
     *     for an Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> updateWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error(new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        if (linkedStorageAccountsProperties == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter linkedStorageAccountsProperties is required and cannot be null."));
        } else {
            linkedStorageAccountsProperties.validate();
        }
        final String apiVersion = "2020-03-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            storageType,
                            linkedStorageAccountsProperties,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update a linked storage accounts
     *     for an Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ComponentLinkedStorageAccountsInner>> updateWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error(new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        if (linkedStorageAccountsProperties == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter linkedStorageAccountsProperties is required and cannot be null."));
        } else {
            linkedStorageAccountsProperties.validate();
        }
        final String apiVersion = "2020-03-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                storageType,
                linkedStorageAccountsProperties,
                accept,
                context);
    }

    /**
     * Update linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update a linked storage accounts
     *     for an Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ComponentLinkedStorageAccountsInner> updateAsync(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties) {
        return updateWithResponseAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update a linked storage accounts
     *     for an Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ComponentLinkedStorageAccountsInner update(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties) {
        return updateAsync(resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties).block();
    }

    /**
     * Update linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param linkedStorageAccountsProperties Properties that need to be specified to update a linked storage accounts
     *     for an Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Application Insights component linked storage accounts along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ComponentLinkedStorageAccountsInner> updateWithResponse(
        String resourceGroupName,
        String resourceName,
        StorageType storageType,
        ComponentLinkedStorageAccountsPatch linkedStorageAccountsProperties,
        Context context) {
        return updateWithResponseAsync(
                resourceGroupName, resourceName, storageType, linkedStorageAccountsProperties, context)
            .block();
    }

    /**
     * Delete linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String resourceName, StorageType storageType) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error(new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        final String apiVersion = "2020-03-01-preview";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            storageType,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (storageType == null) {
            return Mono.error(new IllegalArgumentException("Parameter storageType is required and cannot be null."));
        }
        final String apiVersion = "2020-03-01-preview";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                storageType,
                accept,
                context);
    }

    /**
     * Delete linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, StorageType storageType) {
        return deleteWithResponseAsync(resourceGroupName, resourceName, storageType).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, StorageType storageType) {
        deleteAsync(resourceGroupName, resourceName, storageType).block();
    }

    /**
     * Delete linked storage accounts for an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param storageType The type of the Application Insights component data source for the linked storage account.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(
        String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        return deleteWithResponseAsync(resourceGroupName, resourceName, storageType, context).block();
    }
}
