// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFeatureCapabilitiesInner;

/** An immutable client-side representation of ApplicationInsightsComponentFeatureCapabilities. */
public interface ApplicationInsightsComponentFeatureCapabilities {
    /**
     * Gets the supportExportData property: Whether allow to use continuous export feature.
     *
     * @return the supportExportData value.
     */
    Boolean supportExportData();

    /**
     * Gets the burstThrottlePolicy property: Reserved, not used now.
     *
     * @return the burstThrottlePolicy value.
     */
    String burstThrottlePolicy();

    /**
     * Gets the metadataClass property: Reserved, not used now.
     *
     * @return the metadataClass value.
     */
    String metadataClass();

    /**
     * Gets the liveStreamMetrics property: Reserved, not used now.
     *
     * @return the liveStreamMetrics value.
     */
    Boolean liveStreamMetrics();

    /**
     * Gets the applicationMap property: Reserved, not used now.
     *
     * @return the applicationMap value.
     */
    Boolean applicationMap();

    /**
     * Gets the workItemIntegration property: Whether allow to use work item integration feature.
     *
     * @return the workItemIntegration value.
     */
    Boolean workItemIntegration();

    /**
     * Gets the powerBIIntegration property: Reserved, not used now.
     *
     * @return the powerBIIntegration value.
     */
    Boolean powerBIIntegration();

    /**
     * Gets the openSchema property: Reserved, not used now.
     *
     * @return the openSchema value.
     */
    Boolean openSchema();

    /**
     * Gets the proactiveDetection property: Reserved, not used now.
     *
     * @return the proactiveDetection value.
     */
    Boolean proactiveDetection();

    /**
     * Gets the analyticsIntegration property: Reserved, not used now.
     *
     * @return the analyticsIntegration value.
     */
    Boolean analyticsIntegration();

    /**
     * Gets the multipleStepWebTest property: Whether allow to use multiple steps web test feature.
     *
     * @return the multipleStepWebTest value.
     */
    Boolean multipleStepWebTest();

    /**
     * Gets the apiAccessLevel property: Reserved, not used now.
     *
     * @return the apiAccessLevel value.
     */
    String apiAccessLevel();

    /**
     * Gets the trackingType property: The application insights component used tracking type.
     *
     * @return the trackingType value.
     */
    String trackingType();

    /**
     * Gets the dailyCap property: Daily data volume cap in GB.
     *
     * @return the dailyCap value.
     */
    Float dailyCap();

    /**
     * Gets the dailyCapResetTime property: Daily data volume cap UTC reset hour.
     *
     * @return the dailyCapResetTime value.
     */
    Float dailyCapResetTime();

    /**
     * Gets the throttleRate property: Reserved, not used now.
     *
     * @return the throttleRate value.
     */
    Float throttleRate();

    /**
     * Gets the inner
     * com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFeatureCapabilitiesInner
     * object.
     *
     * @return the inner object.
     */
    ApplicationInsightsComponentFeatureCapabilitiesInner innerModel();
}
