// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for WebTestKind. */
public enum WebTestKind {
    /** Enum value ping. */
    PING("ping"),

    /** Enum value multistep. */
    MULTISTEP("multistep");

    /** The actual serialized value for a WebTestKind instance. */
    private final String value;

    WebTestKind(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a WebTestKind instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed WebTestKind object, or null if unable to parse.
     */
    @JsonCreator
    public static WebTestKind fromString(String value) {
        WebTestKind[] items = WebTestKind.values();
        for (WebTestKind item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
