/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentLinkedStorageAccountsOperationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ComponentLinkedStorageAccountsInner;
import com.azure.resourcemanager.applicationinsights.implementation.ComponentLinkedStorageAccountsImpl;
import com.azure.resourcemanager.applicationinsights.implementation.Utils;
import com.azure.resourcemanager.applicationinsights.models.ComponentLinkedStorageAccounts;
import com.azure.resourcemanager.applicationinsights.models.ComponentLinkedStorageAccountsOperations;
import com.azure.resourcemanager.applicationinsights.models.StorageType;

public final class ComponentLinkedStorageAccountsOperationsImpl
implements ComponentLinkedStorageAccountsOperations {
    private static final ClientLogger LOGGER = new ClientLogger(ComponentLinkedStorageAccountsOperationsImpl.class);
    private final ComponentLinkedStorageAccountsOperationsClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public ComponentLinkedStorageAccountsOperationsImpl(ComponentLinkedStorageAccountsOperationsClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ComponentLinkedStorageAccounts get(String resourceGroupName, String resourceName, StorageType storageType) {
        ComponentLinkedStorageAccountsInner inner = this.serviceClient().get(resourceGroupName, resourceName, storageType);
        if (inner != null) {
            return new ComponentLinkedStorageAccountsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ComponentLinkedStorageAccounts> getWithResponse(String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        Response<ComponentLinkedStorageAccountsInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, storageType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComponentLinkedStorageAccountsImpl((ComponentLinkedStorageAccountsInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String resourceName, StorageType storageType) {
        this.serviceClient().delete(resourceGroupName, resourceName, storageType);
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, StorageType storageType, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, storageType, context);
    }

    @Override
    public ComponentLinkedStorageAccounts getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        StorageType storageType = StorageType.fromString(Utils.getValueFromIdByName(id, "linkedStorageAccounts"));
        if (storageType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedStorageAccounts'.", id)));
        }
        return (ComponentLinkedStorageAccounts)this.getWithResponse(resourceGroupName, resourceName, storageType, Context.NONE).getValue();
    }

    @Override
    public Response<ComponentLinkedStorageAccounts> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        StorageType storageType = StorageType.fromString(Utils.getValueFromIdByName(id, "linkedStorageAccounts"));
        if (storageType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedStorageAccounts'.", id)));
        }
        return this.getWithResponse(resourceGroupName, resourceName, storageType, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        StorageType storageType = StorageType.fromString(Utils.getValueFromIdByName(id, "linkedStorageAccounts"));
        if (storageType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedStorageAccounts'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, resourceName, storageType, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String resourceName = Utils.getValueFromIdByName(id, "components");
        if (resourceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'components'.", id)));
        }
        StorageType storageType = StorageType.fromString(Utils.getValueFromIdByName(id, "linkedStorageAccounts"));
        if (storageType == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'linkedStorageAccounts'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, resourceName, storageType, context);
    }

    private ComponentLinkedStorageAccountsOperationsClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }

    @Override
    public ComponentLinkedStorageAccountsImpl define(StorageType name) {
        return new ComponentLinkedStorageAccountsImpl(name, this.manager());
    }
}

