// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFavoriteInner;
import com.azure.resourcemanager.applicationinsights.models.FavoriteSourceType;
import com.azure.resourcemanager.applicationinsights.models.FavoriteType;
import java.util.List;

/** An instance of this class provides access to all the operations defined in FavoritesClient. */
public interface FavoritesClient {
    /**
     * Gets a list of favorites defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteType The type of favorite. Value can be either shared or user.
     * @param sourceType Source type of favorite to return. When left out, the source type defaults to 'other' (not
     *     present in this enum).
     * @param canFetchContent Flag indicating whether or not to return the full content for each applicable favorite. If
     *     false, only return summary content for favorites.
     * @param tags Tags that must be present on each favorite returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of favorites defined within an Application Insights component along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<ApplicationInsightsComponentFavoriteInner>> listWithResponse(
        String resourceGroupName,
        String resourceName,
        FavoriteType favoriteType,
        FavoriteSourceType sourceType,
        Boolean canFetchContent,
        List<String> tags,
        Context context);

    /**
     * Gets a list of favorites defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of favorites defined within an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<ApplicationInsightsComponentFavoriteInner> list(String resourceGroupName, String resourceName);

    /**
     * Get a single favorite by its FavoriteId, defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single favorite by its FavoriteId, defined within an Application Insights component along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApplicationInsightsComponentFavoriteInner> getWithResponse(
        String resourceGroupName, String resourceName, String favoriteId, Context context);

    /**
     * Get a single favorite by its FavoriteId, defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single favorite by its FavoriteId, defined within an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApplicationInsightsComponentFavoriteInner get(String resourceGroupName, String resourceName, String favoriteId);

    /**
     * Adds a new favorites to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to create a new favorite and add it to an
     *     Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApplicationInsightsComponentFavoriteInner> addWithResponse(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties,
        Context context);

    /**
     * Adds a new favorites to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to create a new favorite and add it to an
     *     Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApplicationInsightsComponentFavoriteInner add(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties);

    /**
     * Updates a favorite that has already been added to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to update the existing favorite.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApplicationInsightsComponentFavoriteInner> updateWithResponse(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties,
        Context context);

    /**
     * Updates a favorite that has already been added to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to update the existing favorite.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApplicationInsightsComponentFavoriteInner update(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties);

    /**
     * Remove a favorite that is associated to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(
        String resourceGroupName, String resourceName, String favoriteId, Context context);

    /**
     * Remove a favorite that is associated to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String resourceName, String favoriteId);
}
