// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentProactiveDetectionConfigurationInner;
import java.util.List;

/**
 * An instance of this class provides access to all the operations defined in ProactiveDetectionConfigurationsClient.
 */
public interface ProactiveDetectionConfigurationsClient {
    /**
     * Gets a list of ProactiveDetection configurations of an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of ProactiveDetection configurations of an Application Insights component along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<ApplicationInsightsComponentProactiveDetectionConfigurationInner>> listWithResponse(
        String resourceGroupName, String resourceName, Context context);

    /**
     * Gets a list of ProactiveDetection configurations of an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of ProactiveDetection configurations of an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<ApplicationInsightsComponentProactiveDetectionConfigurationInner> list(
        String resourceGroupName, String resourceName);

    /**
     * Get the ProactiveDetection configuration for this configuration id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param configurationId The ProactiveDetection configuration ID. This is unique within a Application Insights
     *     component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ProactiveDetection configuration for this configuration id along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner> getWithResponse(
        String resourceGroupName, String resourceName, String configurationId, Context context);

    /**
     * Get the ProactiveDetection configuration for this configuration id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param configurationId The ProactiveDetection configuration ID. This is unique within a Application Insights
     *     component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ProactiveDetection configuration for this configuration id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApplicationInsightsComponentProactiveDetectionConfigurationInner get(
        String resourceGroupName, String resourceName, String configurationId);

    /**
     * Update the ProactiveDetection configuration for this configuration id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param configurationId The ProactiveDetection configuration ID. This is unique within a Application Insights
     *     component.
     * @param proactiveDetectionProperties Properties that need to be specified to update the ProactiveDetection
     *     configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a ProactiveDetection configuration along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApplicationInsightsComponentProactiveDetectionConfigurationInner> updateWithResponse(
        String resourceGroupName,
        String resourceName,
        String configurationId,
        ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties,
        Context context);

    /**
     * Update the ProactiveDetection configuration for this configuration id.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param configurationId The ProactiveDetection configuration ID. This is unique within a Application Insights
     *     component.
     * @param proactiveDetectionProperties Properties that need to be specified to update the ProactiveDetection
     *     configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a ProactiveDetection configuration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApplicationInsightsComponentProactiveDetectionConfigurationInner update(
        String resourceGroupName,
        String resourceName,
        String configurationId,
        ApplicationInsightsComponentProactiveDetectionConfigurationInner proactiveDetectionProperties);
}
