// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentAnalyticsItemProperties;
import com.azure.resourcemanager.applicationinsights.models.ItemScope;
import com.azure.resourcemanager.applicationinsights.models.ItemType;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties that define an Analytics item that is associated to an Application Insights component. */
@Fluent
public final class ApplicationInsightsComponentAnalyticsItemInner {
    /*
     * Internally assigned unique id of the item definition.
     */
    @JsonProperty(value = "Id")
    private String id;

    /*
     * The user-defined name of the item.
     */
    @JsonProperty(value = "Name")
    private String name;

    /*
     * The content of this item
     */
    @JsonProperty(value = "Content")
    private String content;

    /*
     * This instance's version of the data model. This can change as new features are added.
     */
    @JsonProperty(value = "Version", access = JsonProperty.Access.WRITE_ONLY)
    private String version;

    /*
     * Enum indicating if this item definition is owned by a specific user or is shared between all users with access
     * to the Application Insights component.
     */
    @JsonProperty(value = "Scope")
    private ItemScope scope;

    /*
     * Enum indicating the type of the Analytics item.
     */
    @JsonProperty(value = "Type")
    private ItemType type;

    /*
     * Date and time in UTC when this item was created.
     */
    @JsonProperty(value = "TimeCreated", access = JsonProperty.Access.WRITE_ONLY)
    private String timeCreated;

    /*
     * Date and time in UTC of the last modification that was made to this item.
     */
    @JsonProperty(value = "TimeModified", access = JsonProperty.Access.WRITE_ONLY)
    private String timeModified;

    /*
     * A set of properties that can be defined in the context of a specific item type. Each type may have its own
     * properties.
     */
    @JsonProperty(value = "Properties")
    private ApplicationInsightsComponentAnalyticsItemProperties properties;

    /** Creates an instance of ApplicationInsightsComponentAnalyticsItemInner class. */
    public ApplicationInsightsComponentAnalyticsItemInner() {
    }

    /**
     * Get the id property: Internally assigned unique id of the item definition.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Internally assigned unique id of the item definition.
     *
     * @param id the id value to set.
     * @return the ApplicationInsightsComponentAnalyticsItemInner object itself.
     */
    public ApplicationInsightsComponentAnalyticsItemInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The user-defined name of the item.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The user-defined name of the item.
     *
     * @param name the name value to set.
     * @return the ApplicationInsightsComponentAnalyticsItemInner object itself.
     */
    public ApplicationInsightsComponentAnalyticsItemInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the content property: The content of this item.
     *
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of this item.
     *
     * @param content the content value to set.
     * @return the ApplicationInsightsComponentAnalyticsItemInner object itself.
     */
    public ApplicationInsightsComponentAnalyticsItemInner withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the version property: This instance's version of the data model. This can change as new features are added.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Get the scope property: Enum indicating if this item definition is owned by a specific user or is shared between
     * all users with access to the Application Insights component.
     *
     * @return the scope value.
     */
    public ItemScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: Enum indicating if this item definition is owned by a specific user or is shared between
     * all users with access to the Application Insights component.
     *
     * @param scope the scope value to set.
     * @return the ApplicationInsightsComponentAnalyticsItemInner object itself.
     */
    public ApplicationInsightsComponentAnalyticsItemInner withScope(ItemScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the type property: Enum indicating the type of the Analytics item.
     *
     * @return the type value.
     */
    public ItemType type() {
        return this.type;
    }

    /**
     * Set the type property: Enum indicating the type of the Analytics item.
     *
     * @param type the type value to set.
     * @return the ApplicationInsightsComponentAnalyticsItemInner object itself.
     */
    public ApplicationInsightsComponentAnalyticsItemInner withType(ItemType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the timeCreated property: Date and time in UTC when this item was created.
     *
     * @return the timeCreated value.
     */
    public String timeCreated() {
        return this.timeCreated;
    }

    /**
     * Get the timeModified property: Date and time in UTC of the last modification that was made to this item.
     *
     * @return the timeModified value.
     */
    public String timeModified() {
        return this.timeModified;
    }

    /**
     * Get the properties property: A set of properties that can be defined in the context of a specific item type. Each
     * type may have its own properties.
     *
     * @return the properties value.
     */
    public ApplicationInsightsComponentAnalyticsItemProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: A set of properties that can be defined in the context of a specific item type. Each
     * type may have its own properties.
     *
     * @param properties the properties value to set.
     * @return the ApplicationInsightsComponentAnalyticsItemInner object itself.
     */
    public ApplicationInsightsComponentAnalyticsItemInner withProperties(
        ApplicationInsightsComponentAnalyticsItemProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
