// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentFeature;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** An Application Insights component available features. */
@Immutable
public final class ApplicationInsightsComponentAvailableFeaturesInner {
    /*
     * A list of Application Insights component feature.
     */
    @JsonProperty(value = "Result", access = JsonProperty.Access.WRITE_ONLY)
    private List<ApplicationInsightsComponentFeature> result;

    /** Creates an instance of ApplicationInsightsComponentAvailableFeaturesInner class. */
    public ApplicationInsightsComponentAvailableFeaturesInner() {
    }

    /**
     * Get the result property: A list of Application Insights component feature.
     *
     * @return the result value.
     */
    public List<ApplicationInsightsComponentFeature> result() {
        return this.result;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (result() != null) {
            result().forEach(e -> e.validate());
        }
    }
}
