// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties that define a Continuous Export configuration. */
@Fluent
public final class ApplicationInsightsComponentExportConfigurationInner {
    /*
     * The unique ID of the export configuration inside an Application Insights component. It is auto generated when
     * the Continuous Export configuration is created.
     */
    @JsonProperty(value = "ExportId", access = JsonProperty.Access.WRITE_ONLY)
    private String exportId;

    /*
     * The instrumentation key of the Application Insights component.
     */
    @JsonProperty(value = "InstrumentationKey", access = JsonProperty.Access.WRITE_ONLY)
    private String instrumentationKey;

    /*
     * This comma separated list of document types that will be exported. The possible values include 'Requests',
     * 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd', 'PerformanceCounters',
     * 'Availability', 'Messages'.
     */
    @JsonProperty(value = "RecordTypes")
    private String recordTypes;

    /*
     * The name of the Application Insights component.
     */
    @JsonProperty(value = "ApplicationName", access = JsonProperty.Access.WRITE_ONLY)
    private String applicationName;

    /*
     * The subscription of the Application Insights component.
     */
    @JsonProperty(value = "SubscriptionId", access = JsonProperty.Access.WRITE_ONLY)
    private String subscriptionId;

    /*
     * The resource group of the Application Insights component.
     */
    @JsonProperty(value = "ResourceGroup", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceGroup;

    /*
     * The destination storage account subscription ID.
     */
    @JsonProperty(value = "DestinationStorageSubscriptionId", access = JsonProperty.Access.WRITE_ONLY)
    private String destinationStorageSubscriptionId;

    /*
     * The destination account location ID.
     */
    @JsonProperty(value = "DestinationStorageLocationId", access = JsonProperty.Access.WRITE_ONLY)
    private String destinationStorageLocationId;

    /*
     * The name of destination account.
     */
    @JsonProperty(value = "DestinationAccountId", access = JsonProperty.Access.WRITE_ONLY)
    private String destinationAccountId;

    /*
     * The destination type.
     */
    @JsonProperty(value = "DestinationType", access = JsonProperty.Access.WRITE_ONLY)
    private String destinationType;

    /*
     * This will be 'true' if the Continuous Export configuration is enabled, otherwise it will be 'false'.
     */
    @JsonProperty(value = "IsUserEnabled", access = JsonProperty.Access.WRITE_ONLY)
    private String isUserEnabled;

    /*
     * Last time the Continuous Export configuration was updated.
     */
    @JsonProperty(value = "LastUserUpdate", access = JsonProperty.Access.WRITE_ONLY)
    private String lastUserUpdate;

    /*
     * Deprecated
     */
    @JsonProperty(value = "NotificationQueueEnabled")
    private String notificationQueueEnabled;

    /*
     * This indicates current Continuous Export configuration status. The possible values are 'Preparing', 'Success',
     * 'Failure'.
     */
    @JsonProperty(value = "ExportStatus", access = JsonProperty.Access.WRITE_ONLY)
    private String exportStatus;

    /*
     * The last time data was successfully delivered to the destination storage container for this Continuous Export
     * configuration.
     */
    @JsonProperty(value = "LastSuccessTime", access = JsonProperty.Access.WRITE_ONLY)
    private String lastSuccessTime;

    /*
     * The last time the Continuous Export configuration started failing.
     */
    @JsonProperty(value = "LastGapTime", access = JsonProperty.Access.WRITE_ONLY)
    private String lastGapTime;

    /*
     * This is the reason the Continuous Export configuration started failing. It can be 'AzureStorageNotFound' or
     * 'AzureStorageAccessDenied'.
     */
    @JsonProperty(value = "PermanentErrorReason", access = JsonProperty.Access.WRITE_ONLY)
    private String permanentErrorReason;

    /*
     * The name of the destination storage account.
     */
    @JsonProperty(value = "StorageName", access = JsonProperty.Access.WRITE_ONLY)
    private String storageName;

    /*
     * The name of the destination storage container.
     */
    @JsonProperty(value = "ContainerName", access = JsonProperty.Access.WRITE_ONLY)
    private String containerName;

    /** Creates an instance of ApplicationInsightsComponentExportConfigurationInner class. */
    public ApplicationInsightsComponentExportConfigurationInner() {
    }

    /**
     * Get the exportId property: The unique ID of the export configuration inside an Application Insights component. It
     * is auto generated when the Continuous Export configuration is created.
     *
     * @return the exportId value.
     */
    public String exportId() {
        return this.exportId;
    }

    /**
     * Get the instrumentationKey property: The instrumentation key of the Application Insights component.
     *
     * @return the instrumentationKey value.
     */
    public String instrumentationKey() {
        return this.instrumentationKey;
    }

    /**
     * Get the recordTypes property: This comma separated list of document types that will be exported. The possible
     * values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd',
     * 'PerformanceCounters', 'Availability', 'Messages'.
     *
     * @return the recordTypes value.
     */
    public String recordTypes() {
        return this.recordTypes;
    }

    /**
     * Set the recordTypes property: This comma separated list of document types that will be exported. The possible
     * values include 'Requests', 'Event', 'Exceptions', 'Metrics', 'PageViews', 'PageViewPerformance', 'Rdd',
     * 'PerformanceCounters', 'Availability', 'Messages'.
     *
     * @param recordTypes the recordTypes value to set.
     * @return the ApplicationInsightsComponentExportConfigurationInner object itself.
     */
    public ApplicationInsightsComponentExportConfigurationInner withRecordTypes(String recordTypes) {
        this.recordTypes = recordTypes;
        return this;
    }

    /**
     * Get the applicationName property: The name of the Application Insights component.
     *
     * @return the applicationName value.
     */
    public String applicationName() {
        return this.applicationName;
    }

    /**
     * Get the subscriptionId property: The subscription of the Application Insights component.
     *
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Get the resourceGroup property: The resource group of the Application Insights component.
     *
     * @return the resourceGroup value.
     */
    public String resourceGroup() {
        return this.resourceGroup;
    }

    /**
     * Get the destinationStorageSubscriptionId property: The destination storage account subscription ID.
     *
     * @return the destinationStorageSubscriptionId value.
     */
    public String destinationStorageSubscriptionId() {
        return this.destinationStorageSubscriptionId;
    }

    /**
     * Get the destinationStorageLocationId property: The destination account location ID.
     *
     * @return the destinationStorageLocationId value.
     */
    public String destinationStorageLocationId() {
        return this.destinationStorageLocationId;
    }

    /**
     * Get the destinationAccountId property: The name of destination account.
     *
     * @return the destinationAccountId value.
     */
    public String destinationAccountId() {
        return this.destinationAccountId;
    }

    /**
     * Get the destinationType property: The destination type.
     *
     * @return the destinationType value.
     */
    public String destinationType() {
        return this.destinationType;
    }

    /**
     * Get the isUserEnabled property: This will be 'true' if the Continuous Export configuration is enabled, otherwise
     * it will be 'false'.
     *
     * @return the isUserEnabled value.
     */
    public String isUserEnabled() {
        return this.isUserEnabled;
    }

    /**
     * Get the lastUserUpdate property: Last time the Continuous Export configuration was updated.
     *
     * @return the lastUserUpdate value.
     */
    public String lastUserUpdate() {
        return this.lastUserUpdate;
    }

    /**
     * Get the notificationQueueEnabled property: Deprecated.
     *
     * @return the notificationQueueEnabled value.
     */
    public String notificationQueueEnabled() {
        return this.notificationQueueEnabled;
    }

    /**
     * Set the notificationQueueEnabled property: Deprecated.
     *
     * @param notificationQueueEnabled the notificationQueueEnabled value to set.
     * @return the ApplicationInsightsComponentExportConfigurationInner object itself.
     */
    public ApplicationInsightsComponentExportConfigurationInner withNotificationQueueEnabled(
        String notificationQueueEnabled) {
        this.notificationQueueEnabled = notificationQueueEnabled;
        return this;
    }

    /**
     * Get the exportStatus property: This indicates current Continuous Export configuration status. The possible values
     * are 'Preparing', 'Success', 'Failure'.
     *
     * @return the exportStatus value.
     */
    public String exportStatus() {
        return this.exportStatus;
    }

    /**
     * Get the lastSuccessTime property: The last time data was successfully delivered to the destination storage
     * container for this Continuous Export configuration.
     *
     * @return the lastSuccessTime value.
     */
    public String lastSuccessTime() {
        return this.lastSuccessTime;
    }

    /**
     * Get the lastGapTime property: The last time the Continuous Export configuration started failing.
     *
     * @return the lastGapTime value.
     */
    public String lastGapTime() {
        return this.lastGapTime;
    }

    /**
     * Get the permanentErrorReason property: This is the reason the Continuous Export configuration started failing. It
     * can be 'AzureStorageNotFound' or 'AzureStorageAccessDenied'.
     *
     * @return the permanentErrorReason value.
     */
    public String permanentErrorReason() {
        return this.permanentErrorReason;
    }

    /**
     * Get the storageName property: The name of the destination storage account.
     *
     * @return the storageName value.
     */
    public String storageName() {
        return this.storageName;
    }

    /**
     * Get the containerName property: The name of the destination storage container.
     *
     * @return the containerName value.
     */
    public String containerName() {
        return this.containerName;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
