// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An Application Insights component feature capabilities. */
@Immutable
public final class ApplicationInsightsComponentFeatureCapabilitiesInner {
    /*
     * Whether allow to use continuous export feature.
     */
    @JsonProperty(value = "SupportExportData", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean supportExportData;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "BurstThrottlePolicy", access = JsonProperty.Access.WRITE_ONLY)
    private String burstThrottlePolicy;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "MetadataClass", access = JsonProperty.Access.WRITE_ONLY)
    private String metadataClass;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "LiveStreamMetrics", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean liveStreamMetrics;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "ApplicationMap", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean applicationMap;

    /*
     * Whether allow to use work item integration feature.
     */
    @JsonProperty(value = "WorkItemIntegration", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean workItemIntegration;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "PowerBIIntegration", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean powerBIIntegration;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "OpenSchema", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean openSchema;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "ProactiveDetection", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean proactiveDetection;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "AnalyticsIntegration", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean analyticsIntegration;

    /*
     * Whether allow to use multiple steps web test feature.
     */
    @JsonProperty(value = "MultipleStepWebTest", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean multipleStepWebTest;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "ApiAccessLevel", access = JsonProperty.Access.WRITE_ONLY)
    private String apiAccessLevel;

    /*
     * The application insights component used tracking type.
     */
    @JsonProperty(value = "TrackingType", access = JsonProperty.Access.WRITE_ONLY)
    private String trackingType;

    /*
     * Daily data volume cap in GB.
     */
    @JsonProperty(value = "DailyCap", access = JsonProperty.Access.WRITE_ONLY)
    private Float dailyCap;

    /*
     * Daily data volume cap UTC reset hour.
     */
    @JsonProperty(value = "DailyCapResetTime", access = JsonProperty.Access.WRITE_ONLY)
    private Float dailyCapResetTime;

    /*
     * Reserved, not used now.
     */
    @JsonProperty(value = "ThrottleRate", access = JsonProperty.Access.WRITE_ONLY)
    private Float throttleRate;

    /** Creates an instance of ApplicationInsightsComponentFeatureCapabilitiesInner class. */
    public ApplicationInsightsComponentFeatureCapabilitiesInner() {
    }

    /**
     * Get the supportExportData property: Whether allow to use continuous export feature.
     *
     * @return the supportExportData value.
     */
    public Boolean supportExportData() {
        return this.supportExportData;
    }

    /**
     * Get the burstThrottlePolicy property: Reserved, not used now.
     *
     * @return the burstThrottlePolicy value.
     */
    public String burstThrottlePolicy() {
        return this.burstThrottlePolicy;
    }

    /**
     * Get the metadataClass property: Reserved, not used now.
     *
     * @return the metadataClass value.
     */
    public String metadataClass() {
        return this.metadataClass;
    }

    /**
     * Get the liveStreamMetrics property: Reserved, not used now.
     *
     * @return the liveStreamMetrics value.
     */
    public Boolean liveStreamMetrics() {
        return this.liveStreamMetrics;
    }

    /**
     * Get the applicationMap property: Reserved, not used now.
     *
     * @return the applicationMap value.
     */
    public Boolean applicationMap() {
        return this.applicationMap;
    }

    /**
     * Get the workItemIntegration property: Whether allow to use work item integration feature.
     *
     * @return the workItemIntegration value.
     */
    public Boolean workItemIntegration() {
        return this.workItemIntegration;
    }

    /**
     * Get the powerBIIntegration property: Reserved, not used now.
     *
     * @return the powerBIIntegration value.
     */
    public Boolean powerBIIntegration() {
        return this.powerBIIntegration;
    }

    /**
     * Get the openSchema property: Reserved, not used now.
     *
     * @return the openSchema value.
     */
    public Boolean openSchema() {
        return this.openSchema;
    }

    /**
     * Get the proactiveDetection property: Reserved, not used now.
     *
     * @return the proactiveDetection value.
     */
    public Boolean proactiveDetection() {
        return this.proactiveDetection;
    }

    /**
     * Get the analyticsIntegration property: Reserved, not used now.
     *
     * @return the analyticsIntegration value.
     */
    public Boolean analyticsIntegration() {
        return this.analyticsIntegration;
    }

    /**
     * Get the multipleStepWebTest property: Whether allow to use multiple steps web test feature.
     *
     * @return the multipleStepWebTest value.
     */
    public Boolean multipleStepWebTest() {
        return this.multipleStepWebTest;
    }

    /**
     * Get the apiAccessLevel property: Reserved, not used now.
     *
     * @return the apiAccessLevel value.
     */
    public String apiAccessLevel() {
        return this.apiAccessLevel;
    }

    /**
     * Get the trackingType property: The application insights component used tracking type.
     *
     * @return the trackingType value.
     */
    public String trackingType() {
        return this.trackingType;
    }

    /**
     * Get the dailyCap property: Daily data volume cap in GB.
     *
     * @return the dailyCap value.
     */
    public Float dailyCap() {
        return this.dailyCap;
    }

    /**
     * Get the dailyCapResetTime property: Daily data volume cap UTC reset hour.
     *
     * @return the dailyCapResetTime value.
     */
    public Float dailyCapResetTime() {
        return this.dailyCapResetTime;
    }

    /**
     * Get the throttleRate property: Reserved, not used now.
     *
     * @return the throttleRate value.
     */
    public Float throttleRate() {
        return this.throttleRate;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
