// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.models.ApplicationType;
import com.azure.resourcemanager.applicationinsights.models.FlowType;
import com.azure.resourcemanager.applicationinsights.models.IngestionMode;
import com.azure.resourcemanager.applicationinsights.models.PrivateLinkScopedResource;
import com.azure.resourcemanager.applicationinsights.models.PublicNetworkAccessType;
import com.azure.resourcemanager.applicationinsights.models.RequestSource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Properties that define an Application Insights component resource. */
@Fluent
public final class ApplicationInsightsComponentProperties {
    /*
     * The unique ID of your application. This field mirrors the 'Name' field and cannot be changed.
     */
    @JsonProperty(value = "ApplicationId", access = JsonProperty.Access.WRITE_ONLY)
    private String applicationId;

    /*
     * Application Insights Unique ID for your Application.
     */
    @JsonProperty(value = "AppId", access = JsonProperty.Access.WRITE_ONLY)
    private String appId;

    /*
     * Application name.
     */
    @JsonProperty(value = "Name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Type of application being monitored.
     */
    @JsonProperty(value = "Application_Type", required = true)
    private ApplicationType applicationType;

    /*
     * Used by the Application Insights system to determine what kind of flow this component was created by. This is to
     * be set to 'Bluefield' when creating/updating a component via the REST API.
     */
    @JsonProperty(value = "Flow_Type")
    private FlowType flowType;

    /*
     * Describes what tool created this Application Insights component. Customers using this API should set this to the
     * default 'rest'.
     */
    @JsonProperty(value = "Request_Source")
    private RequestSource requestSource;

    /*
     * Application Insights Instrumentation key. A read-only value that applications can use to identify the
     * destination for all telemetry sent to Azure Application Insights. This value will be supplied upon construction
     * of each new Application Insights component.
     */
    @JsonProperty(value = "InstrumentationKey", access = JsonProperty.Access.WRITE_ONLY)
    private String instrumentationKey;

    /*
     * Creation Date for the Application Insights component, in ISO 8601 format.
     */
    @JsonProperty(value = "CreationDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;

    /*
     * Azure Tenant Id.
     */
    @JsonProperty(value = "TenantId", access = JsonProperty.Access.WRITE_ONLY)
    private String tenantId;

    /*
     * The unique application ID created when a new application is added to HockeyApp, used for communications with
     * HockeyApp.
     */
    @JsonProperty(value = "HockeyAppId")
    private String hockeyAppId;

    /*
     * Token used to authenticate communications with between Application Insights and HockeyApp.
     */
    @JsonProperty(value = "HockeyAppToken", access = JsonProperty.Access.WRITE_ONLY)
    private String hockeyAppToken;

    /*
     * Current state of this component: whether or not is has been provisioned within the resource group it is defined.
     * Users cannot change this value but are able to read from it. Values will include Succeeded, Deploying, Canceled,
     * and Failed.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * Percentage of the data produced by the application being monitored that is being sampled for Application
     * Insights telemetry.
     */
    @JsonProperty(value = "SamplingPercentage")
    private Double samplingPercentage;

    /*
     * Application Insights component connection string.
     */
    @JsonProperty(value = "ConnectionString", access = JsonProperty.Access.WRITE_ONLY)
    private String connectionString;

    /*
     * Retention period in days.
     */
    @JsonProperty(value = "RetentionInDays")
    private Integer retentionInDays;

    /*
     * Disable IP masking.
     */
    @JsonProperty(value = "DisableIpMasking")
    private Boolean disableIpMasking;

    /*
     * Purge data immediately after 30 days.
     */
    @JsonProperty(value = "ImmediatePurgeDataOn30Days")
    private Boolean immediatePurgeDataOn30Days;

    /*
     * Resource Id of the log analytics workspace which the data will be ingested to. This property is required to
     * create an application with this API version. Applications from older versions will not have this property.
     */
    @JsonProperty(value = "WorkspaceResourceId")
    private String workspaceResourceId;

    /*
     * The date which the component got migrated to LA, in ISO 8601 format.
     */
    @JsonProperty(value = "LaMigrationDate", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime laMigrationDate;

    /*
     * List of linked private link scope resources.
     */
    @JsonProperty(value = "PrivateLinkScopedResources", access = JsonProperty.Access.WRITE_ONLY)
    private List<PrivateLinkScopedResource> privateLinkScopedResources;

    /*
     * The network access type for accessing Application Insights ingestion.
     */
    @JsonProperty(value = "publicNetworkAccessForIngestion")
    private PublicNetworkAccessType publicNetworkAccessForIngestion;

    /*
     * The network access type for accessing Application Insights query.
     */
    @JsonProperty(value = "publicNetworkAccessForQuery")
    private PublicNetworkAccessType publicNetworkAccessForQuery;

    /*
     * Indicates the flow of the ingestion.
     */
    @JsonProperty(value = "IngestionMode")
    private IngestionMode ingestionMode;

    /*
     * Disable Non-AAD based Auth.
     */
    @JsonProperty(value = "DisableLocalAuth")
    private Boolean disableLocalAuth;

    /*
     * Force users to create their own storage account for profiler and debugger.
     */
    @JsonProperty(value = "ForceCustomerStorageForProfiler")
    private Boolean forceCustomerStorageForProfiler;

    /** Creates an instance of ApplicationInsightsComponentProperties class. */
    public ApplicationInsightsComponentProperties() {
    }

    /**
     * Get the applicationId property: The unique ID of your application. This field mirrors the 'Name' field and cannot
     * be changed.
     *
     * @return the applicationId value.
     */
    public String applicationId() {
        return this.applicationId;
    }

    /**
     * Get the appId property: Application Insights Unique ID for your Application.
     *
     * @return the appId value.
     */
    public String appId() {
        return this.appId;
    }

    /**
     * Get the name property: Application name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the applicationType property: Type of application being monitored.
     *
     * @return the applicationType value.
     */
    public ApplicationType applicationType() {
        return this.applicationType;
    }

    /**
     * Set the applicationType property: Type of application being monitored.
     *
     * @param applicationType the applicationType value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    /**
     * Get the flowType property: Used by the Application Insights system to determine what kind of flow this component
     * was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
     *
     * @return the flowType value.
     */
    public FlowType flowType() {
        return this.flowType;
    }

    /**
     * Set the flowType property: Used by the Application Insights system to determine what kind of flow this component
     * was created by. This is to be set to 'Bluefield' when creating/updating a component via the REST API.
     *
     * @param flowType the flowType value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withFlowType(FlowType flowType) {
        this.flowType = flowType;
        return this;
    }

    /**
     * Get the requestSource property: Describes what tool created this Application Insights component. Customers using
     * this API should set this to the default 'rest'.
     *
     * @return the requestSource value.
     */
    public RequestSource requestSource() {
        return this.requestSource;
    }

    /**
     * Set the requestSource property: Describes what tool created this Application Insights component. Customers using
     * this API should set this to the default 'rest'.
     *
     * @param requestSource the requestSource value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withRequestSource(RequestSource requestSource) {
        this.requestSource = requestSource;
        return this;
    }

    /**
     * Get the instrumentationKey property: Application Insights Instrumentation key. A read-only value that
     * applications can use to identify the destination for all telemetry sent to Azure Application Insights. This value
     * will be supplied upon construction of each new Application Insights component.
     *
     * @return the instrumentationKey value.
     */
    public String instrumentationKey() {
        return this.instrumentationKey;
    }

    /**
     * Get the creationDate property: Creation Date for the Application Insights component, in ISO 8601 format.
     *
     * @return the creationDate value.
     */
    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    /**
     * Get the tenantId property: Azure Tenant Id.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the hockeyAppId property: The unique application ID created when a new application is added to HockeyApp,
     * used for communications with HockeyApp.
     *
     * @return the hockeyAppId value.
     */
    public String hockeyAppId() {
        return this.hockeyAppId;
    }

    /**
     * Set the hockeyAppId property: The unique application ID created when a new application is added to HockeyApp,
     * used for communications with HockeyApp.
     *
     * @param hockeyAppId the hockeyAppId value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withHockeyAppId(String hockeyAppId) {
        this.hockeyAppId = hockeyAppId;
        return this;
    }

    /**
     * Get the hockeyAppToken property: Token used to authenticate communications with between Application Insights and
     * HockeyApp.
     *
     * @return the hockeyAppToken value.
     */
    public String hockeyAppToken() {
        return this.hockeyAppToken;
    }

    /**
     * Get the provisioningState property: Current state of this component: whether or not is has been provisioned
     * within the resource group it is defined. Users cannot change this value but are able to read from it. Values will
     * include Succeeded, Deploying, Canceled, and Failed.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the samplingPercentage property: Percentage of the data produced by the application being monitored that is
     * being sampled for Application Insights telemetry.
     *
     * @return the samplingPercentage value.
     */
    public Double samplingPercentage() {
        return this.samplingPercentage;
    }

    /**
     * Set the samplingPercentage property: Percentage of the data produced by the application being monitored that is
     * being sampled for Application Insights telemetry.
     *
     * @param samplingPercentage the samplingPercentage value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
        return this;
    }

    /**
     * Get the connectionString property: Application Insights component connection string.
     *
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Get the retentionInDays property: Retention period in days.
     *
     * @return the retentionInDays value.
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set the retentionInDays property: Retention period in days.
     *
     * @param retentionInDays the retentionInDays value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    /**
     * Get the disableIpMasking property: Disable IP masking.
     *
     * @return the disableIpMasking value.
     */
    public Boolean disableIpMasking() {
        return this.disableIpMasking;
    }

    /**
     * Set the disableIpMasking property: Disable IP masking.
     *
     * @param disableIpMasking the disableIpMasking value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withDisableIpMasking(Boolean disableIpMasking) {
        this.disableIpMasking = disableIpMasking;
        return this;
    }

    /**
     * Get the immediatePurgeDataOn30Days property: Purge data immediately after 30 days.
     *
     * @return the immediatePurgeDataOn30Days value.
     */
    public Boolean immediatePurgeDataOn30Days() {
        return this.immediatePurgeDataOn30Days;
    }

    /**
     * Set the immediatePurgeDataOn30Days property: Purge data immediately after 30 days.
     *
     * @param immediatePurgeDataOn30Days the immediatePurgeDataOn30Days value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withImmediatePurgeDataOn30Days(Boolean immediatePurgeDataOn30Days) {
        this.immediatePurgeDataOn30Days = immediatePurgeDataOn30Days;
        return this;
    }

    /**
     * Get the workspaceResourceId property: Resource Id of the log analytics workspace which the data will be ingested
     * to. This property is required to create an application with this API version. Applications from older versions
     * will not have this property.
     *
     * @return the workspaceResourceId value.
     */
    public String workspaceResourceId() {
        return this.workspaceResourceId;
    }

    /**
     * Set the workspaceResourceId property: Resource Id of the log analytics workspace which the data will be ingested
     * to. This property is required to create an application with this API version. Applications from older versions
     * will not have this property.
     *
     * @param workspaceResourceId the workspaceResourceId value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withWorkspaceResourceId(String workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    /**
     * Get the laMigrationDate property: The date which the component got migrated to LA, in ISO 8601 format.
     *
     * @return the laMigrationDate value.
     */
    public OffsetDateTime laMigrationDate() {
        return this.laMigrationDate;
    }

    /**
     * Get the privateLinkScopedResources property: List of linked private link scope resources.
     *
     * @return the privateLinkScopedResources value.
     */
    public List<PrivateLinkScopedResource> privateLinkScopedResources() {
        return this.privateLinkScopedResources;
    }

    /**
     * Get the publicNetworkAccessForIngestion property: The network access type for accessing Application Insights
     * ingestion.
     *
     * @return the publicNetworkAccessForIngestion value.
     */
    public PublicNetworkAccessType publicNetworkAccessForIngestion() {
        return this.publicNetworkAccessForIngestion;
    }

    /**
     * Set the publicNetworkAccessForIngestion property: The network access type for accessing Application Insights
     * ingestion.
     *
     * @param publicNetworkAccessForIngestion the publicNetworkAccessForIngestion value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withPublicNetworkAccessForIngestion(
        PublicNetworkAccessType publicNetworkAccessForIngestion) {
        this.publicNetworkAccessForIngestion = publicNetworkAccessForIngestion;
        return this;
    }

    /**
     * Get the publicNetworkAccessForQuery property: The network access type for accessing Application Insights query.
     *
     * @return the publicNetworkAccessForQuery value.
     */
    public PublicNetworkAccessType publicNetworkAccessForQuery() {
        return this.publicNetworkAccessForQuery;
    }

    /**
     * Set the publicNetworkAccessForQuery property: The network access type for accessing Application Insights query.
     *
     * @param publicNetworkAccessForQuery the publicNetworkAccessForQuery value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withPublicNetworkAccessForQuery(
        PublicNetworkAccessType publicNetworkAccessForQuery) {
        this.publicNetworkAccessForQuery = publicNetworkAccessForQuery;
        return this;
    }

    /**
     * Get the ingestionMode property: Indicates the flow of the ingestion.
     *
     * @return the ingestionMode value.
     */
    public IngestionMode ingestionMode() {
        return this.ingestionMode;
    }

    /**
     * Set the ingestionMode property: Indicates the flow of the ingestion.
     *
     * @param ingestionMode the ingestionMode value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withIngestionMode(IngestionMode ingestionMode) {
        this.ingestionMode = ingestionMode;
        return this;
    }

    /**
     * Get the disableLocalAuth property: Disable Non-AAD based Auth.
     *
     * @return the disableLocalAuth value.
     */
    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    /**
     * Set the disableLocalAuth property: Disable Non-AAD based Auth.
     *
     * @param disableLocalAuth the disableLocalAuth value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    /**
     * Get the forceCustomerStorageForProfiler property: Force users to create their own storage account for profiler
     * and debugger.
     *
     * @return the forceCustomerStorageForProfiler value.
     */
    public Boolean forceCustomerStorageForProfiler() {
        return this.forceCustomerStorageForProfiler;
    }

    /**
     * Set the forceCustomerStorageForProfiler property: Force users to create their own storage account for profiler
     * and debugger.
     *
     * @param forceCustomerStorageForProfiler the forceCustomerStorageForProfiler value to set.
     * @return the ApplicationInsightsComponentProperties object itself.
     */
    public ApplicationInsightsComponentProperties withForceCustomerStorageForProfiler(
        Boolean forceCustomerStorageForProfiler) {
        this.forceCustomerStorageForProfiler = forceCustomerStorageForProfiler;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (applicationType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property applicationType in model ApplicationInsightsComponentProperties"));
        }
        if (privateLinkScopedResources() != null) {
            privateLinkScopedResources().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApplicationInsightsComponentProperties.class);
}
