// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Properties that contain a private workbook. */
@Fluent
public final class MyWorkbookProperties {
    /*
     * The user-defined name of the private workbook.
     */
    @JsonProperty(value = "displayName", required = true)
    private String displayName;

    /*
     * Configuration of this particular private workbook. Configuration data is a string containing valid JSON
     */
    @JsonProperty(value = "serializedData", required = true)
    private String serializedData;

    /*
     * This instance's version of the data model. This can change as new features are added that can be marked private
     * workbook.
     */
    @JsonProperty(value = "version")
    private String version;

    /*
     * Date and time in UTC of the last modification that was made to this private workbook definition.
     */
    @JsonProperty(value = "timeModified", access = JsonProperty.Access.WRITE_ONLY)
    private String timeModified;

    /*
     * Workbook category, as defined by the user at creation time.
     */
    @JsonProperty(value = "category", required = true)
    private String category;

    /*
     * A list of 0 or more tags that are associated with this private workbook definition
     */
    @JsonProperty(value = "tags")
    private List<String> tags;

    /*
     * Unique user id of the specific user that owns this private workbook.
     */
    @JsonProperty(value = "userId", access = JsonProperty.Access.WRITE_ONLY)
    private String userId;

    /*
     * Optional resourceId for a source resource.
     */
    @JsonProperty(value = "sourceId")
    private String sourceId;

    /*
     * BYOS Storage Account URI
     */
    @JsonProperty(value = "storageUri")
    private String storageUri;

    /** Creates an instance of MyWorkbookProperties class. */
    public MyWorkbookProperties() {
    }

    /**
     * Get the displayName property: The user-defined name of the private workbook.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The user-defined name of the private workbook.
     *
     * @param displayName the displayName value to set.
     * @return the MyWorkbookProperties object itself.
     */
    public MyWorkbookProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the serializedData property: Configuration of this particular private workbook. Configuration data is a
     * string containing valid JSON.
     *
     * @return the serializedData value.
     */
    public String serializedData() {
        return this.serializedData;
    }

    /**
     * Set the serializedData property: Configuration of this particular private workbook. Configuration data is a
     * string containing valid JSON.
     *
     * @param serializedData the serializedData value to set.
     * @return the MyWorkbookProperties object itself.
     */
    public MyWorkbookProperties withSerializedData(String serializedData) {
        this.serializedData = serializedData;
        return this;
    }

    /**
     * Get the version property: This instance's version of the data model. This can change as new features are added
     * that can be marked private workbook.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: This instance's version of the data model. This can change as new features are added
     * that can be marked private workbook.
     *
     * @param version the version value to set.
     * @return the MyWorkbookProperties object itself.
     */
    public MyWorkbookProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the timeModified property: Date and time in UTC of the last modification that was made to this private
     * workbook definition.
     *
     * @return the timeModified value.
     */
    public String timeModified() {
        return this.timeModified;
    }

    /**
     * Get the category property: Workbook category, as defined by the user at creation time.
     *
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Set the category property: Workbook category, as defined by the user at creation time.
     *
     * @param category the category value to set.
     * @return the MyWorkbookProperties object itself.
     */
    public MyWorkbookProperties withCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the tags property: A list of 0 or more tags that are associated with this private workbook definition.
     *
     * @return the tags value.
     */
    public List<String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: A list of 0 or more tags that are associated with this private workbook definition.
     *
     * @param tags the tags value to set.
     * @return the MyWorkbookProperties object itself.
     */
    public MyWorkbookProperties withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the userId property: Unique user id of the specific user that owns this private workbook.
     *
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Get the sourceId property: Optional resourceId for a source resource.
     *
     * @return the sourceId value.
     */
    public String sourceId() {
        return this.sourceId;
    }

    /**
     * Set the sourceId property: Optional resourceId for a source resource.
     *
     * @param sourceId the sourceId value to set.
     * @return the MyWorkbookProperties object itself.
     */
    public MyWorkbookProperties withSourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    /**
     * Get the storageUri property: BYOS Storage Account URI.
     *
     * @return the storageUri value.
     */
    public String storageUri() {
        return this.storageUri;
    }

    /**
     * Set the storageUri property: BYOS Storage Account URI.
     *
     * @param storageUri the storageUri value to set.
     * @return the MyWorkbookProperties object itself.
     */
    public MyWorkbookProperties withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (displayName() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property displayName in model MyWorkbookProperties"));
        }
        if (serializedData() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property serializedData in model MyWorkbookProperties"));
        }
        if (category() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property category in model MyWorkbookProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MyWorkbookProperties.class);
}
