// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Work item configuration associated with an application insights resource. */
@Fluent
public final class WorkItemConfigurationInner {
    /*
     * Connector identifier where work item is created
     */
    @JsonProperty(value = "ConnectorId")
    private String connectorId;

    /*
     * Configuration friendly name
     */
    @JsonProperty(value = "ConfigDisplayName")
    private String configDisplayName;

    /*
     * Boolean value indicating whether configuration is default
     */
    @JsonProperty(value = "IsDefault")
    private Boolean isDefault;

    /*
     * Unique Id for work item
     */
    @JsonProperty(value = "Id")
    private String id;

    /*
     * Serialized JSON object for detailed properties
     */
    @JsonProperty(value = "ConfigProperties")
    private String configProperties;

    /** Creates an instance of WorkItemConfigurationInner class. */
    public WorkItemConfigurationInner() {
    }

    /**
     * Get the connectorId property: Connector identifier where work item is created.
     *
     * @return the connectorId value.
     */
    public String connectorId() {
        return this.connectorId;
    }

    /**
     * Set the connectorId property: Connector identifier where work item is created.
     *
     * @param connectorId the connectorId value to set.
     * @return the WorkItemConfigurationInner object itself.
     */
    public WorkItemConfigurationInner withConnectorId(String connectorId) {
        this.connectorId = connectorId;
        return this;
    }

    /**
     * Get the configDisplayName property: Configuration friendly name.
     *
     * @return the configDisplayName value.
     */
    public String configDisplayName() {
        return this.configDisplayName;
    }

    /**
     * Set the configDisplayName property: Configuration friendly name.
     *
     * @param configDisplayName the configDisplayName value to set.
     * @return the WorkItemConfigurationInner object itself.
     */
    public WorkItemConfigurationInner withConfigDisplayName(String configDisplayName) {
        this.configDisplayName = configDisplayName;
        return this;
    }

    /**
     * Get the isDefault property: Boolean value indicating whether configuration is default.
     *
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: Boolean value indicating whether configuration is default.
     *
     * @param isDefault the isDefault value to set.
     * @return the WorkItemConfigurationInner object itself.
     */
    public WorkItemConfigurationInner withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the id property: Unique Id for work item.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Unique Id for work item.
     *
     * @param id the id value to set.
     * @return the WorkItemConfigurationInner object itself.
     */
    public WorkItemConfigurationInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the configProperties property: Serialized JSON object for detailed properties.
     *
     * @return the configProperties value.
     */
    public String configProperties() {
        return this.configProperties;
    }

    /**
     * Set the configProperties property: Serialized JSON object for detailed properties.
     *
     * @param configProperties the configProperties value to set.
     * @return the WorkItemConfigurationInner object itself.
     */
    public WorkItemConfigurationInner withConfigProperties(String configProperties) {
        this.configProperties = configProperties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
