// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.applicationinsights.models.WorkbookResource;
import com.azure.resourcemanager.applicationinsights.models.WorkbookResourceIdentity;
import com.azure.resourcemanager.applicationinsights.models.WorkbookSharedTypeKind;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** A workbook definition. */
@Fluent
public final class WorkbookInner extends WorkbookResource {
    /*
     * Metadata describing a workbook for an Azure resource.
     */
    @JsonProperty(value = "properties")
    private WorkbookProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /** Creates an instance of WorkbookInner class. */
    public WorkbookInner() {
    }

    /**
     * Get the innerProperties property: Metadata describing a workbook for an Azure resource.
     *
     * @return the innerProperties value.
     */
    private WorkbookProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /** {@inheritDoc} */
    @Override
    public WorkbookInner withIdentity(WorkbookResourceIdentity identity) {
        super.withIdentity(identity);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WorkbookInner withKind(WorkbookSharedTypeKind kind) {
        super.withKind(kind);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WorkbookInner withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WorkbookInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public WorkbookInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the displayName property: The user-defined name (display name) of the workbook.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: The user-defined name (display name) of the workbook.
     *
     * @param displayName the displayName value to set.
     * @return the WorkbookInner object itself.
     */
    public WorkbookInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the serializedData property: Configuration of this particular workbook. Configuration data is a string
     * containing valid JSON.
     *
     * @return the serializedData value.
     */
    public String serializedData() {
        return this.innerProperties() == null ? null : this.innerProperties().serializedData();
    }

    /**
     * Set the serializedData property: Configuration of this particular workbook. Configuration data is a string
     * containing valid JSON.
     *
     * @param serializedData the serializedData value to set.
     * @return the WorkbookInner object itself.
     */
    public WorkbookInner withSerializedData(String serializedData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withSerializedData(serializedData);
        return this;
    }

    /**
     * Get the version property: Workbook schema version format, like 'Notebook/1.0', which should match the workbook in
     * serializedData.
     *
     * @return the version value.
     */
    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: Workbook schema version format, like 'Notebook/1.0', which should match the workbook in
     * serializedData.
     *
     * @param version the version value to set.
     * @return the WorkbookInner object itself.
     */
    public WorkbookInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Get the timeModified property: Date and time in UTC of the last modification that was made to this workbook
     * definition.
     *
     * @return the timeModified value.
     */
    public OffsetDateTime timeModified() {
        return this.innerProperties() == null ? null : this.innerProperties().timeModified();
    }

    /**
     * Get the category property: Workbook category, as defined by the user at creation time.
     *
     * @return the category value.
     */
    public String category() {
        return this.innerProperties() == null ? null : this.innerProperties().category();
    }

    /**
     * Set the category property: Workbook category, as defined by the user at creation time.
     *
     * @param category the category value to set.
     * @return the WorkbookInner object itself.
     */
    public WorkbookInner withCategory(String category) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withCategory(category);
        return this;
    }

    /**
     * Get the tags property: Being deprecated, please use the other tags field.
     *
     * @return the tags value.
     */
    public List<String> tagsPropertiesTags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    /**
     * Set the tags property: Being deprecated, please use the other tags field.
     *
     * @param tags the tags value to set.
     * @return the WorkbookInner object itself.
     */
    public WorkbookInner withTagsPropertiesTags(List<String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    /**
     * Get the userId property: Unique user id of the specific user that owns this workbook.
     *
     * @return the userId value.
     */
    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    /**
     * Get the sourceId property: ResourceId for a source resource.
     *
     * @return the sourceId value.
     */
    public String sourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceId();
    }

    /**
     * Set the sourceId property: ResourceId for a source resource.
     *
     * @param sourceId the sourceId value to set.
     * @return the WorkbookInner object itself.
     */
    public WorkbookInner withSourceId(String sourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withSourceId(sourceId);
        return this;
    }

    /**
     * Get the storageUri property: The resourceId to the storage account when bring your own storage is used.
     *
     * @return the storageUri value.
     */
    public String storageUri() {
        return this.innerProperties() == null ? null : this.innerProperties().storageUri();
    }

    /**
     * Set the storageUri property: The resourceId to the storage account when bring your own storage is used.
     *
     * @param storageUri the storageUri value to set.
     * @return the WorkbookInner object itself.
     */
    public WorkbookInner withStorageUri(String storageUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withStorageUri(storageUri);
        return this;
    }

    /**
     * Get the description property: The description of the workbook.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The description of the workbook.
     *
     * @param description the description value to set.
     * @return the WorkbookInner object itself.
     */
    public WorkbookInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkbookProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the revision property: The unique revision id for this workbook definition.
     *
     * @return the revision value.
     */
    public String revision() {
        return this.innerProperties() == null ? null : this.innerProperties().revision();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
