// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.applicationinsights.fluent.AnalyticsItemsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentAnalyticsItemInner;
import com.azure.resourcemanager.applicationinsights.models.ItemScope;
import com.azure.resourcemanager.applicationinsights.models.ItemScopePath;
import com.azure.resourcemanager.applicationinsights.models.ItemTypeParameter;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in AnalyticsItemsClient. */
public final class AnalyticsItemsClientImpl implements AnalyticsItemsClient {
    /** The proxy service used to perform REST calls. */
    private final AnalyticsItemsService service;

    /** The service client containing this operation class. */
    private final ApplicationInsightsManagementClientImpl client;

    /**
     * Initializes an instance of AnalyticsItemsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    AnalyticsItemsClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service =
            RestProxy.create(AnalyticsItemsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ApplicationInsightsManagementClientAnalyticsItems to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ApplicationInsightsM")
    public interface AnalyticsItemsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<List<ApplicationInsightsComponentAnalyticsItemInner>>> list(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceName") String resourceName,
            @PathParam("scopePath") ItemScopePath scopePath,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("scope") ItemScope scope,
            @QueryParam("type") ItemTypeParameter type,
            @QueryParam("includeContent") Boolean includeContent,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceName") String resourceName,
            @PathParam("scopePath") ItemScopePath scopePath,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("id") String id,
            @QueryParam("name") String name,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> put(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceName") String resourceName,
            @PathParam("scopePath") ItemScopePath scopePath,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("overrideItem") Boolean overrideItem,
            @BodyParam("application/json") ApplicationInsightsComponentAnalyticsItemInner itemProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("resourceName") String resourceName,
            @PathParam("scopePath") ItemScopePath scopePath,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("id") String id,
            @QueryParam("name") String name,
            Context context);
    }

    /**
     * Gets a list of Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param scope Enum indicating if this item definition is owned by a specific user or is shared between all users
     *     with access to the Application Insights component.
     * @param type Enum indicating the type of the Analytics item.
     * @param includeContent Flag indicating whether or not to return the content of each applicable item. If false,
     *     only return the item information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Analytics Items defined within an Application Insights component along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<ApplicationInsightsComponentAnalyticsItemInner>>> listWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        ItemScope scope,
        ItemTypeParameter type,
        Boolean includeContent) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            resourceName,
                            scopePath,
                            apiVersion,
                            scope,
                            type,
                            includeContent,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param scope Enum indicating if this item definition is owned by a specific user or is shared between all users
     *     with access to the Application Insights component.
     * @param type Enum indicating the type of the Analytics item.
     * @param includeContent Flag indicating whether or not to return the content of each applicable item. If false,
     *     only return the item information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Analytics Items defined within an Application Insights component along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<ApplicationInsightsComponentAnalyticsItemInner>>> listWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        ItemScope scope,
        ItemTypeParameter type,
        Boolean includeContent,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                resourceName,
                scopePath,
                apiVersion,
                scope,
                type,
                includeContent,
                accept,
                context);
    }

    /**
     * Gets a list of Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Analytics Items defined within an Application Insights component on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<List<ApplicationInsightsComponentAnalyticsItemInner>> listAsync(
        String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        final ItemScope scope = null;
        final ItemTypeParameter type = null;
        final Boolean includeContent = null;
        return listWithResponseAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a list of Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param scope Enum indicating if this item definition is owned by a specific user or is shared between all users
     *     with access to the Application Insights component.
     * @param type Enum indicating the type of the Analytics item.
     * @param includeContent Flag indicating whether or not to return the content of each applicable item. If false,
     *     only return the item information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Analytics Items defined within an Application Insights component along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<ApplicationInsightsComponentAnalyticsItemInner>> listWithResponse(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        ItemScope scope,
        ItemTypeParameter type,
        Boolean includeContent,
        Context context) {
        return listWithResponseAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent, context)
            .block();
    }

    /**
     * Gets a list of Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of Analytics Items defined within an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<ApplicationInsightsComponentAnalyticsItemInner> list(
        String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        final ItemScope scope = null;
        final ItemTypeParameter type = null;
        final Boolean includeContent = null;
        return listWithResponse(resourceGroupName, resourceName, scopePath, scope, type, includeContent, Context.NONE)
            .getValue();
    }

    /**
     * Gets a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param id The Id of a specific item defined in the Application Insights component.
     * @param name The name of a specific item defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Analytics Items defined within an Application Insights component along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> getWithResponseAsync(
        String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            resourceName,
                            scopePath,
                            apiVersion,
                            id,
                            name,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param id The Id of a specific item defined in the Application Insights component.
     * @param name The name of a specific item defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Analytics Items defined within an Application Insights component along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> getWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        String id,
        String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                resourceName,
                scopePath,
                apiVersion,
                id,
                name,
                accept,
                context);
    }

    /**
     * Gets a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Analytics Items defined within an Application Insights component on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ApplicationInsightsComponentAnalyticsItemInner> getAsync(
        String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        final String id = null;
        final String name = null;
        return getWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param id The Id of a specific item defined in the Application Insights component.
     * @param name The name of a specific item defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Analytics Items defined within an Application Insights component along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApplicationInsightsComponentAnalyticsItemInner> getWithResponse(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        String id,
        String name,
        Context context) {
        return getWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name, context).block();
    }

    /**
     * Gets a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a specific Analytics Items defined within an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApplicationInsightsComponentAnalyticsItemInner get(
        String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        final String id = null;
        final String name = null;
        return getWithResponse(resourceGroupName, resourceName, scopePath, id, name, Context.NONE).getValue();
    }

    /**
     * Adds or Updates a specific Analytics Item within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param itemProperties Properties that need to be specified to create a new item and add it to an Application
     *     Insights component.
     * @param overrideItem Flag indicating whether or not to force save an item. This allows overriding an item if it
     *     already exists.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define an Analytics item that is associated to an Application Insights component along
     *     with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> putWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        ApplicationInsightsComponentAnalyticsItemInner itemProperties,
        Boolean overrideItem) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        if (itemProperties == null) {
            return Mono.error(new IllegalArgumentException("Parameter itemProperties is required and cannot be null."));
        } else {
            itemProperties.validate();
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .put(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            resourceName,
                            scopePath,
                            apiVersion,
                            overrideItem,
                            itemProperties,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Adds or Updates a specific Analytics Item within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param itemProperties Properties that need to be specified to create a new item and add it to an Application
     *     Insights component.
     * @param overrideItem Flag indicating whether or not to force save an item. This allows overriding an item if it
     *     already exists.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define an Analytics item that is associated to an Application Insights component along
     *     with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentAnalyticsItemInner>> putWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        ApplicationInsightsComponentAnalyticsItemInner itemProperties,
        Boolean overrideItem,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        if (itemProperties == null) {
            return Mono.error(new IllegalArgumentException("Parameter itemProperties is required and cannot be null."));
        } else {
            itemProperties.validate();
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .put(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                resourceName,
                scopePath,
                apiVersion,
                overrideItem,
                itemProperties,
                accept,
                context);
    }

    /**
     * Adds or Updates a specific Analytics Item within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param itemProperties Properties that need to be specified to create a new item and add it to an Application
     *     Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define an Analytics item that is associated to an Application Insights component on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ApplicationInsightsComponentAnalyticsItemInner> putAsync(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        ApplicationInsightsComponentAnalyticsItemInner itemProperties) {
        final Boolean overrideItem = null;
        return putWithResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Adds or Updates a specific Analytics Item within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param itemProperties Properties that need to be specified to create a new item and add it to an Application
     *     Insights component.
     * @param overrideItem Flag indicating whether or not to force save an item. This allows overriding an item if it
     *     already exists.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define an Analytics item that is associated to an Application Insights component along
     *     with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApplicationInsightsComponentAnalyticsItemInner> putWithResponse(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        ApplicationInsightsComponentAnalyticsItemInner itemProperties,
        Boolean overrideItem,
        Context context) {
        return putWithResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem, context)
            .block();
    }

    /**
     * Adds or Updates a specific Analytics Item within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param itemProperties Properties that need to be specified to create a new item and add it to an Application
     *     Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define an Analytics item that is associated to an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApplicationInsightsComponentAnalyticsItemInner put(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        ApplicationInsightsComponentAnalyticsItemInner itemProperties) {
        final Boolean overrideItem = null;
        return putWithResponse(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem, Context.NONE)
            .getValue();
    }

    /**
     * Deletes a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param id The Id of a specific item defined in the Application Insights component.
     * @param name The name of a specific item defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            resourceName,
                            scopePath,
                            apiVersion,
                            id,
                            name,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param id The Id of a specific item defined in the Application Insights component.
     * @param name The name of a specific item defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        String id,
        String name,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (scopePath == null) {
            return Mono.error(new IllegalArgumentException("Parameter scopePath is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                resourceName,
                scopePath,
                apiVersion,
                id,
                name,
                context);
    }

    /**
     * Deletes a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        final String id = null;
        final String name = null;
        return deleteWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @param id The Id of a specific item defined in the Application Insights component.
     * @param name The name of a specific item defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(
        String resourceGroupName,
        String resourceName,
        ItemScopePath scopePath,
        String id,
        String name,
        Context context) {
        return deleteWithResponseAsync(resourceGroupName, resourceName, scopePath, id, name, context).block();
    }

    /**
     * Deletes a specific Analytics Items defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param scopePath Enum indicating if this item definition is owned by a specific user or is shared between all
     *     users with access to the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        final String id = null;
        final String name = null;
        deleteWithResponse(resourceGroupName, resourceName, scopePath, id, name, Context.NONE);
    }
}
