// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFavoriteInner;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentFavorite;
import com.azure.resourcemanager.applicationinsights.models.FavoriteType;
import java.util.Collections;
import java.util.List;

public final class ApplicationInsightsComponentFavoriteImpl implements ApplicationInsightsComponentFavorite {
    private ApplicationInsightsComponentFavoriteInner innerObject;

    private final com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager;

    ApplicationInsightsComponentFavoriteImpl(
        ApplicationInsightsComponentFavoriteInner innerObject,
        com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String name() {
        return this.innerModel().name();
    }

    public String config() {
        return this.innerModel().config();
    }

    public String version() {
        return this.innerModel().version();
    }

    public String favoriteId() {
        return this.innerModel().favoriteId();
    }

    public FavoriteType favoriteType() {
        return this.innerModel().favoriteType();
    }

    public String sourceType() {
        return this.innerModel().sourceType();
    }

    public String timeModified() {
        return this.innerModel().timeModified();
    }

    public List<String> tags() {
        List<String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        } else {
            return Collections.emptyList();
        }
    }

    public String category() {
        return this.innerModel().category();
    }

    public Boolean isGeneratedFromTemplate() {
        return this.innerModel().isGeneratedFromTemplate();
    }

    public String userId() {
        return this.innerModel().userId();
    }

    public ApplicationInsightsComponentFavoriteInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}
