// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentFeatureCapabilitiesClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFeatureCapabilitiesInner;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentFeatureCapabilities;
import com.azure.resourcemanager.applicationinsights.models.ComponentFeatureCapabilities;

public final class ComponentFeatureCapabilitiesImpl implements ComponentFeatureCapabilities {
    private static final ClientLogger LOGGER = new ClientLogger(ComponentFeatureCapabilitiesImpl.class);

    private final ComponentFeatureCapabilitiesClient innerClient;

    private final com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager;

    public ComponentFeatureCapabilitiesImpl(
        ComponentFeatureCapabilitiesClient innerClient,
        com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<ApplicationInsightsComponentFeatureCapabilities> getWithResponse(
        String resourceGroupName, String resourceName, Context context) {
        Response<ApplicationInsightsComponentFeatureCapabilitiesInner> inner =
            this.serviceClient().getWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ApplicationInsightsComponentFeatureCapabilitiesImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApplicationInsightsComponentFeatureCapabilities get(String resourceGroupName, String resourceName) {
        ApplicationInsightsComponentFeatureCapabilitiesInner inner =
            this.serviceClient().get(resourceGroupName, resourceName);
        if (inner != null) {
            return new ApplicationInsightsComponentFeatureCapabilitiesImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ComponentFeatureCapabilitiesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}
