// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.fluent.ExportConfigurationsClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentExportConfigurationInner;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentExportConfiguration;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentExportRequest;
import com.azure.resourcemanager.applicationinsights.models.ExportConfigurations;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ExportConfigurationsImpl implements ExportConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(ExportConfigurationsImpl.class);

    private final ExportConfigurationsClient innerClient;

    private final com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager;

    public ExportConfigurationsImpl(
        ExportConfigurationsClient innerClient,
        com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<List<ApplicationInsightsComponentExportConfiguration>> listWithResponse(
        String resourceGroupName, String resourceName, Context context) {
        Response<List<ApplicationInsightsComponentExportConfigurationInner>> inner =
            this.serviceClient().listWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                inner
                    .getValue()
                    .stream()
                    .map(inner1 -> new ApplicationInsightsComponentExportConfigurationImpl(inner1, this.manager()))
                    .collect(Collectors.toList()));
        } else {
            return null;
        }
    }

    public List<ApplicationInsightsComponentExportConfiguration> list(String resourceGroupName, String resourceName) {
        List<ApplicationInsightsComponentExportConfigurationInner> inner =
            this.serviceClient().list(resourceGroupName, resourceName);
        if (inner != null) {
            return Collections
                .unmodifiableList(
                    inner
                        .stream()
                        .map(inner1 -> new ApplicationInsightsComponentExportConfigurationImpl(inner1, this.manager()))
                        .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public Response<List<ApplicationInsightsComponentExportConfiguration>> createWithResponse(
        String resourceGroupName,
        String resourceName,
        ApplicationInsightsComponentExportRequest exportProperties,
        Context context) {
        Response<List<ApplicationInsightsComponentExportConfigurationInner>> inner =
            this.serviceClient().createWithResponse(resourceGroupName, resourceName, exportProperties, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                inner
                    .getValue()
                    .stream()
                    .map(inner1 -> new ApplicationInsightsComponentExportConfigurationImpl(inner1, this.manager()))
                    .collect(Collectors.toList()));
        } else {
            return null;
        }
    }

    public List<ApplicationInsightsComponentExportConfiguration> create(
        String resourceGroupName, String resourceName, ApplicationInsightsComponentExportRequest exportProperties) {
        List<ApplicationInsightsComponentExportConfigurationInner> inner =
            this.serviceClient().create(resourceGroupName, resourceName, exportProperties);
        if (inner != null) {
            return Collections
                .unmodifiableList(
                    inner
                        .stream()
                        .map(inner1 -> new ApplicationInsightsComponentExportConfigurationImpl(inner1, this.manager()))
                        .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public Response<ApplicationInsightsComponentExportConfiguration> deleteWithResponse(
        String resourceGroupName, String resourceName, String exportId, Context context) {
        Response<ApplicationInsightsComponentExportConfigurationInner> inner =
            this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, exportId, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ApplicationInsightsComponentExportConfigurationImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApplicationInsightsComponentExportConfiguration delete(
        String resourceGroupName, String resourceName, String exportId) {
        ApplicationInsightsComponentExportConfigurationInner inner =
            this.serviceClient().delete(resourceGroupName, resourceName, exportId);
        if (inner != null) {
            return new ApplicationInsightsComponentExportConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApplicationInsightsComponentExportConfiguration> getWithResponse(
        String resourceGroupName, String resourceName, String exportId, Context context) {
        Response<ApplicationInsightsComponentExportConfigurationInner> inner =
            this.serviceClient().getWithResponse(resourceGroupName, resourceName, exportId, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ApplicationInsightsComponentExportConfigurationImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApplicationInsightsComponentExportConfiguration get(
        String resourceGroupName, String resourceName, String exportId) {
        ApplicationInsightsComponentExportConfigurationInner inner =
            this.serviceClient().get(resourceGroupName, resourceName, exportId);
        if (inner != null) {
            return new ApplicationInsightsComponentExportConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApplicationInsightsComponentExportConfiguration> updateWithResponse(
        String resourceGroupName,
        String resourceName,
        String exportId,
        ApplicationInsightsComponentExportRequest exportProperties,
        Context context) {
        Response<ApplicationInsightsComponentExportConfigurationInner> inner =
            this
                .serviceClient()
                .updateWithResponse(resourceGroupName, resourceName, exportId, exportProperties, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ApplicationInsightsComponentExportConfigurationImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApplicationInsightsComponentExportConfiguration update(
        String resourceGroupName,
        String resourceName,
        String exportId,
        ApplicationInsightsComponentExportRequest exportProperties) {
        ApplicationInsightsComponentExportConfigurationInner inner =
            this.serviceClient().update(resourceGroupName, resourceName, exportId, exportProperties);
        if (inner != null) {
            return new ApplicationInsightsComponentExportConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private ExportConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}
