// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.applicationinsights.fluent.FavoritesClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFavoriteInner;
import com.azure.resourcemanager.applicationinsights.models.FavoriteSourceType;
import com.azure.resourcemanager.applicationinsights.models.FavoriteType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in FavoritesClient. */
public final class FavoritesClientImpl implements FavoritesClient {
    /** The proxy service used to perform REST calls. */
    private final FavoritesService service;

    /** The service client containing this operation class. */
    private final ApplicationInsightsManagementClientImpl client;

    /**
     * Initializes an instance of FavoritesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    FavoritesClientImpl(ApplicationInsightsManagementClientImpl client) {
        this.service =
            RestProxy.create(FavoritesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ApplicationInsightsManagementClientFavorites to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ApplicationInsightsM")
    public interface FavoritesService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<List<ApplicationInsightsComponentFavoriteInner>>> list(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @QueryParam("favoriteType") FavoriteType favoriteType,
            @QueryParam("sourceType") FavoriteSourceType sourceType,
            @QueryParam("canFetchContent") Boolean canFetchContent,
            @QueryParam("tags") String tags,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ApplicationInsightsComponentFavoriteInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @PathParam("favoriteId") String favoriteId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ApplicationInsightsComponentFavoriteInner>> add(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @PathParam("favoriteId") String favoriteId,
            @BodyParam("application/json") ApplicationInsightsComponentFavoriteInner favoriteProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ApplicationInsightsComponentFavoriteInner>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @PathParam("favoriteId") String favoriteId,
            @BodyParam("application/json") ApplicationInsightsComponentFavoriteInner favoriteProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceName") String resourceName,
            @PathParam("favoriteId") String favoriteId,
            Context context);
    }

    /**
     * Gets a list of favorites defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteType The type of favorite. Value can be either shared or user.
     * @param sourceType Source type of favorite to return. When left out, the source type defaults to 'other' (not
     *     present in this enum).
     * @param canFetchContent Flag indicating whether or not to return the full content for each applicable favorite. If
     *     false, only return summary content for favorites.
     * @param tags Tags that must be present on each favorite returned.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of favorites defined within an Application Insights component along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<ApplicationInsightsComponentFavoriteInner>>> listWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        FavoriteType favoriteType,
        FavoriteSourceType sourceType,
        Boolean canFetchContent,
        List<String> tags) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        String tagsConverted =
            (tags == null)
                ? null
                : tags
                    .stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            favoriteType,
                            sourceType,
                            canFetchContent,
                            tagsConverted,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of favorites defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteType The type of favorite. Value can be either shared or user.
     * @param sourceType Source type of favorite to return. When left out, the source type defaults to 'other' (not
     *     present in this enum).
     * @param canFetchContent Flag indicating whether or not to return the full content for each applicable favorite. If
     *     false, only return summary content for favorites.
     * @param tags Tags that must be present on each favorite returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of favorites defined within an Application Insights component along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<ApplicationInsightsComponentFavoriteInner>>> listWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        FavoriteType favoriteType,
        FavoriteSourceType sourceType,
        Boolean canFetchContent,
        List<String> tags,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        String tagsConverted =
            (tags == null)
                ? null
                : tags
                    .stream()
                    .map(paramItemValue -> Objects.toString(paramItemValue, ""))
                    .collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                favoriteType,
                sourceType,
                canFetchContent,
                tagsConverted,
                accept,
                context);
    }

    /**
     * Gets a list of favorites defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of favorites defined within an Application Insights component on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<List<ApplicationInsightsComponentFavoriteInner>> listAsync(
        String resourceGroupName, String resourceName) {
        final FavoriteType favoriteType = null;
        final FavoriteSourceType sourceType = null;
        final Boolean canFetchContent = null;
        final List<String> tags = null;
        return listWithResponseAsync(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a list of favorites defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteType The type of favorite. Value can be either shared or user.
     * @param sourceType Source type of favorite to return. When left out, the source type defaults to 'other' (not
     *     present in this enum).
     * @param canFetchContent Flag indicating whether or not to return the full content for each applicable favorite. If
     *     false, only return summary content for favorites.
     * @param tags Tags that must be present on each favorite returned.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of favorites defined within an Application Insights component along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<ApplicationInsightsComponentFavoriteInner>> listWithResponse(
        String resourceGroupName,
        String resourceName,
        FavoriteType favoriteType,
        FavoriteSourceType sourceType,
        Boolean canFetchContent,
        List<String> tags,
        Context context) {
        return listWithResponseAsync(
                resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags, context)
            .block();
    }

    /**
     * Gets a list of favorites defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of favorites defined within an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<ApplicationInsightsComponentFavoriteInner> list(String resourceGroupName, String resourceName) {
        final FavoriteType favoriteType = null;
        final FavoriteSourceType sourceType = null;
        final Boolean canFetchContent = null;
        final List<String> tags = null;
        return listWithResponse(
                resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags, Context.NONE)
            .getValue();
    }

    /**
     * Get a single favorite by its FavoriteId, defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single favorite by its FavoriteId, defined within an Application Insights component along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> getWithResponseAsync(
        String resourceGroupName, String resourceName, String favoriteId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error(new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            favoriteId,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a single favorite by its FavoriteId, defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single favorite by its FavoriteId, defined within an Application Insights component along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> getWithResponseAsync(
        String resourceGroupName, String resourceName, String favoriteId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error(new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                favoriteId,
                accept,
                context);
    }

    /**
     * Get a single favorite by its FavoriteId, defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single favorite by its FavoriteId, defined within an Application Insights component on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ApplicationInsightsComponentFavoriteInner> getAsync(
        String resourceGroupName, String resourceName, String favoriteId) {
        return getWithResponseAsync(resourceGroupName, resourceName, favoriteId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a single favorite by its FavoriteId, defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single favorite by its FavoriteId, defined within an Application Insights component along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApplicationInsightsComponentFavoriteInner> getWithResponse(
        String resourceGroupName, String resourceName, String favoriteId, Context context) {
        return getWithResponseAsync(resourceGroupName, resourceName, favoriteId, context).block();
    }

    /**
     * Get a single favorite by its FavoriteId, defined within an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single favorite by its FavoriteId, defined within an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApplicationInsightsComponentFavoriteInner get(
        String resourceGroupName, String resourceName, String favoriteId) {
        return getWithResponse(resourceGroupName, resourceName, favoriteId, Context.NONE).getValue();
    }

    /**
     * Adds a new favorites to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to create a new favorite and add it to an
     *     Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> addWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error(new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        if (favoriteProperties == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null."));
        } else {
            favoriteProperties.validate();
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .add(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            favoriteId,
                            favoriteProperties,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Adds a new favorites to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to create a new favorite and add it to an
     *     Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> addWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error(new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        if (favoriteProperties == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null."));
        } else {
            favoriteProperties.validate();
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .add(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                favoriteId,
                favoriteProperties,
                accept,
                context);
    }

    /**
     * Adds a new favorites to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to create a new favorite and add it to an
     *     Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ApplicationInsightsComponentFavoriteInner> addAsync(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return addWithResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Adds a new favorites to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to create a new favorite and add it to an
     *     Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApplicationInsightsComponentFavoriteInner> addWithResponse(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties,
        Context context) {
        return addWithResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties, context).block();
    }

    /**
     * Adds a new favorites to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to create a new favorite and add it to an
     *     Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApplicationInsightsComponentFavoriteInner add(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return addWithResponse(resourceGroupName, resourceName, favoriteId, favoriteProperties, Context.NONE)
            .getValue();
    }

    /**
     * Updates a favorite that has already been added to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to update the existing favorite.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> updateWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error(new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        if (favoriteProperties == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null."));
        } else {
            favoriteProperties.validate();
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            favoriteId,
                            favoriteProperties,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates a favorite that has already been added to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to update the existing favorite.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ApplicationInsightsComponentFavoriteInner>> updateWithResponseAsync(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error(new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        if (favoriteProperties == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null."));
        } else {
            favoriteProperties.validate();
        }
        final String apiVersion = "2015-05-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                favoriteId,
                favoriteProperties,
                accept,
                context);
    }

    /**
     * Updates a favorite that has already been added to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to update the existing favorite.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ApplicationInsightsComponentFavoriteInner> updateAsync(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return updateWithResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates a favorite that has already been added to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to update the existing favorite.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ApplicationInsightsComponentFavoriteInner> updateWithResponse(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties,
        Context context) {
        return updateWithResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties, context)
            .block();
    }

    /**
     * Updates a favorite that has already been added to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param favoriteProperties Properties that need to be specified to update the existing favorite.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return properties that define a favorite that is associated to an Application Insights component.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ApplicationInsightsComponentFavoriteInner update(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return updateWithResponse(resourceGroupName, resourceName, favoriteId, favoriteProperties, Context.NONE)
            .getValue();
    }

    /**
     * Remove a favorite that is associated to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String resourceName, String favoriteId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error(new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            apiVersion,
                            this.client.getSubscriptionId(),
                            resourceName,
                            favoriteId,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Remove a favorite that is associated to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String resourceName, String favoriteId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (favoriteId == null) {
            return Mono.error(new IllegalArgumentException("Parameter favoriteId is required and cannot be null."));
        }
        final String apiVersion = "2015-05-01";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                apiVersion,
                this.client.getSubscriptionId(),
                resourceName,
                favoriteId,
                context);
    }

    /**
     * Remove a favorite that is associated to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String favoriteId) {
        return deleteWithResponseAsync(resourceGroupName, resourceName, favoriteId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Remove a favorite that is associated to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(
        String resourceGroupName, String resourceName, String favoriteId, Context context) {
        return deleteWithResponseAsync(resourceGroupName, resourceName, favoriteId, context).block();
    }

    /**
     * Remove a favorite that is associated to an Application Insights component.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the Application Insights component resource.
     * @param favoriteId The Id of a specific favorite defined in the Application Insights component.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String favoriteId) {
        deleteWithResponse(resourceGroupName, resourceName, favoriteId, Context.NONE);
    }
}
