// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.fluent.FavoritesClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFavoriteInner;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentFavorite;
import com.azure.resourcemanager.applicationinsights.models.FavoriteSourceType;
import com.azure.resourcemanager.applicationinsights.models.FavoriteType;
import com.azure.resourcemanager.applicationinsights.models.Favorites;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class FavoritesImpl implements Favorites {
    private static final ClientLogger LOGGER = new ClientLogger(FavoritesImpl.class);

    private final FavoritesClient innerClient;

    private final com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager;

    public FavoritesImpl(
        FavoritesClient innerClient,
        com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<List<ApplicationInsightsComponentFavorite>> listWithResponse(
        String resourceGroupName,
        String resourceName,
        FavoriteType favoriteType,
        FavoriteSourceType sourceType,
        Boolean canFetchContent,
        List<String> tags,
        Context context) {
        Response<List<ApplicationInsightsComponentFavoriteInner>> inner =
            this
                .serviceClient()
                .listWithResponse(
                    resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                inner
                    .getValue()
                    .stream()
                    .map(inner1 -> new ApplicationInsightsComponentFavoriteImpl(inner1, this.manager()))
                    .collect(Collectors.toList()));
        } else {
            return null;
        }
    }

    public List<ApplicationInsightsComponentFavorite> list(String resourceGroupName, String resourceName) {
        List<ApplicationInsightsComponentFavoriteInner> inner =
            this.serviceClient().list(resourceGroupName, resourceName);
        if (inner != null) {
            return Collections
                .unmodifiableList(
                    inner
                        .stream()
                        .map(inner1 -> new ApplicationInsightsComponentFavoriteImpl(inner1, this.manager()))
                        .collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
    }

    public Response<ApplicationInsightsComponentFavorite> getWithResponse(
        String resourceGroupName, String resourceName, String favoriteId, Context context) {
        Response<ApplicationInsightsComponentFavoriteInner> inner =
            this.serviceClient().getWithResponse(resourceGroupName, resourceName, favoriteId, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ApplicationInsightsComponentFavoriteImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApplicationInsightsComponentFavorite get(String resourceGroupName, String resourceName, String favoriteId) {
        ApplicationInsightsComponentFavoriteInner inner =
            this.serviceClient().get(resourceGroupName, resourceName, favoriteId);
        if (inner != null) {
            return new ApplicationInsightsComponentFavoriteImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApplicationInsightsComponentFavorite> addWithResponse(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties,
        Context context) {
        Response<ApplicationInsightsComponentFavoriteInner> inner =
            this
                .serviceClient()
                .addWithResponse(resourceGroupName, resourceName, favoriteId, favoriteProperties, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ApplicationInsightsComponentFavoriteImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApplicationInsightsComponentFavorite add(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        ApplicationInsightsComponentFavoriteInner inner =
            this.serviceClient().add(resourceGroupName, resourceName, favoriteId, favoriteProperties);
        if (inner != null) {
            return new ApplicationInsightsComponentFavoriteImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ApplicationInsightsComponentFavorite> updateWithResponse(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties,
        Context context) {
        Response<ApplicationInsightsComponentFavoriteInner> inner =
            this
                .serviceClient()
                .updateWithResponse(resourceGroupName, resourceName, favoriteId, favoriteProperties, context);
        if (inner != null) {
            return new SimpleResponse<>(
                inner.getRequest(),
                inner.getStatusCode(),
                inner.getHeaders(),
                new ApplicationInsightsComponentFavoriteImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ApplicationInsightsComponentFavorite update(
        String resourceGroupName,
        String resourceName,
        String favoriteId,
        ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        ApplicationInsightsComponentFavoriteInner inner =
            this.serviceClient().update(resourceGroupName, resourceName, favoriteId, favoriteProperties);
        if (inner != null) {
            return new ApplicationInsightsComponentFavoriteImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(
        String resourceGroupName, String resourceName, String favoriteId, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, resourceName, favoriteId, context);
    }

    public void delete(String resourceGroupName, String resourceName, String favoriteId) {
        this.serviceClient().delete(resourceGroupName, resourceName, favoriteId);
    }

    private FavoritesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}
