// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFavoriteInner;
import java.util.List;

/** An immutable client-side representation of ApplicationInsightsComponentFavorite. */
public interface ApplicationInsightsComponentFavorite {
    /**
     * Gets the name property: The user-defined name of the favorite.
     *
     * @return the name value.
     */
    String name();

    /**
     * Gets the config property: Configuration of this particular favorite, which are driven by the Azure portal UX.
     * Configuration data is a string containing valid JSON.
     *
     * @return the config value.
     */
    String config();

    /**
     * Gets the version property: This instance's version of the data model. This can change as new features are added
     * that can be marked favorite. Current examples include MetricsExplorer (ME) and Search.
     *
     * @return the version value.
     */
    String version();

    /**
     * Gets the favoriteId property: Internally assigned unique id of the favorite definition.
     *
     * @return the favoriteId value.
     */
    String favoriteId();

    /**
     * Gets the favoriteType property: Enum indicating if this favorite definition is owned by a specific user or is
     * shared between all users with access to the Application Insights component.
     *
     * @return the favoriteType value.
     */
    FavoriteType favoriteType();

    /**
     * Gets the sourceType property: The source of the favorite definition.
     *
     * @return the sourceType value.
     */
    String sourceType();

    /**
     * Gets the timeModified property: Date and time in UTC of the last modification that was made to this favorite
     * definition.
     *
     * @return the timeModified value.
     */
    String timeModified();

    /**
     * Gets the tags property: A list of 0 or more tags that are associated with this favorite definition.
     *
     * @return the tags value.
     */
    List<String> tags();

    /**
     * Gets the category property: Favorite category, as defined by the user at creation time.
     *
     * @return the category value.
     */
    String category();

    /**
     * Gets the isGeneratedFromTemplate property: Flag denoting wether or not this favorite was generated from a
     * template.
     *
     * @return the isGeneratedFromTemplate value.
     */
    Boolean isGeneratedFromTemplate();

    /**
     * Gets the userId property: Unique user id of the specific user that owns this favorite.
     *
     * @return the userId value.
     */
    String userId();

    /**
     * Gets the inner
     * com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentFavoriteInner object.
     *
     * @return the inner object.
     */
    ApplicationInsightsComponentFavoriteInner innerModel();
}
