// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An Application Insights component feature capability. */
@Immutable
public final class ApplicationInsightsComponentFeatureCapability {
    /*
     * The name of the capability.
     */
    @JsonProperty(value = "Name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The description of the capability.
     */
    @JsonProperty(value = "Description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /*
     * The value of the capability.
     */
    @JsonProperty(value = "Value", access = JsonProperty.Access.WRITE_ONLY)
    private String value;

    /*
     * The unit of the capability.
     */
    @JsonProperty(value = "Unit", access = JsonProperty.Access.WRITE_ONLY)
    private String unit;

    /*
     * The meter used for the capability.
     */
    @JsonProperty(value = "MeterId", access = JsonProperty.Access.WRITE_ONLY)
    private String meterId;

    /*
     * The meter rate of the meter.
     */
    @JsonProperty(value = "MeterRateFrequency", access = JsonProperty.Access.WRITE_ONLY)
    private String meterRateFrequency;

    /** Creates an instance of ApplicationInsightsComponentFeatureCapability class. */
    public ApplicationInsightsComponentFeatureCapability() {
    }

    /**
     * Get the name property: The name of the capability.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the description property: The description of the capability.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the value property: The value of the capability.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Get the unit property: The unit of the capability.
     *
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the meterId property: The meter used for the capability.
     *
     * @return the meterId value.
     */
    public String meterId() {
        return this.meterId;
    }

    /**
     * Get the meterRateFrequency property: The meter rate of the meter.
     *
     * @return the meterRateFrequency value.
     */
    public String meterRateFrequency() {
        return this.meterRateFrequency;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
