// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Describes the body of a purge request for an App Insights component. */
@Fluent
public final class ComponentPurgeBody {
    /*
     * Table from which to purge data.
     */
    @JsonProperty(value = "table", required = true)
    private String table;

    /*
     * The set of columns and filters (queries) to run over them to purge the resulting data.
     */
    @JsonProperty(value = "filters", required = true)
    private List<ComponentPurgeBodyFilters> filters;

    /** Creates an instance of ComponentPurgeBody class. */
    public ComponentPurgeBody() {
    }

    /**
     * Get the table property: Table from which to purge data.
     *
     * @return the table value.
     */
    public String table() {
        return this.table;
    }

    /**
     * Set the table property: Table from which to purge data.
     *
     * @param table the table value to set.
     * @return the ComponentPurgeBody object itself.
     */
    public ComponentPurgeBody withTable(String table) {
        this.table = table;
        return this;
    }

    /**
     * Get the filters property: The set of columns and filters (queries) to run over them to purge the resulting data.
     *
     * @return the filters value.
     */
    public List<ComponentPurgeBodyFilters> filters() {
        return this.filters;
    }

    /**
     * Set the filters property: The set of columns and filters (queries) to run over them to purge the resulting data.
     *
     * @param filters the filters value to set.
     * @return the ComponentPurgeBody object itself.
     */
    public ComponentPurgeBody withFilters(List<ComponentPurgeBodyFilters> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (table() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property table in model ComponentPurgeBody"));
        }
        if (filters() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property filters in model ComponentPurgeBody"));
        } else {
            filters().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ComponentPurgeBody.class);
}
