// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Used by the Application Insights system to determine what kind of flow this component was created by. This is to be
 * set to 'Bluefield' when creating/updating a component via the REST API.
 */
public final class FlowType extends ExpandableStringEnum<FlowType> {
    /** Static value Bluefield for FlowType. */
    public static final FlowType BLUEFIELD = fromString("Bluefield");

    /**
     * Creates a new instance of FlowType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FlowType() {
    }

    /**
     * Creates or finds a FlowType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FlowType.
     */
    @JsonCreator
    public static FlowType fromString(String name) {
        return fromString(name, FlowType.class);
    }

    /**
     * Gets known FlowType values.
     *
     * @return known FlowType values.
     */
    public static Collection<FlowType> values() {
        return values(FlowType.class);
    }
}
