// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A header to add to the WebTest. */
@Fluent
public final class HeaderField {
    /*
     * The name of the header.
     */
    @JsonProperty(value = "key")
    private String headerFieldName;

    /*
     * The value of the header.
     */
    @JsonProperty(value = "value")
    private String headerFieldValue;

    /** Creates an instance of HeaderField class. */
    public HeaderField() {
    }

    /**
     * Get the headerFieldName property: The name of the header.
     *
     * @return the headerFieldName value.
     */
    public String headerFieldName() {
        return this.headerFieldName;
    }

    /**
     * Set the headerFieldName property: The name of the header.
     *
     * @param headerFieldName the headerFieldName value to set.
     * @return the HeaderField object itself.
     */
    public HeaderField withHeaderFieldName(String headerFieldName) {
        this.headerFieldName = headerFieldName;
        return this;
    }

    /**
     * Get the headerFieldValue property: The value of the header.
     *
     * @return the headerFieldValue value.
     */
    public String headerFieldValue() {
        return this.headerFieldValue;
    }

    /**
     * Set the headerFieldValue property: The value of the header.
     *
     * @param headerFieldValue the headerFieldValue value to set.
     * @return the HeaderField object itself.
     */
    public HeaderField withHeaderFieldValue(String headerFieldValue) {
        this.headerFieldValue = headerFieldValue;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
