// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ItemTypeParameter. */
public final class ItemTypeParameter extends ExpandableStringEnum<ItemTypeParameter> {
    /** Static value none for ItemTypeParameter. */
    public static final ItemTypeParameter NONE = fromString("none");

    /** Static value query for ItemTypeParameter. */
    public static final ItemTypeParameter QUERY = fromString("query");

    /** Static value function for ItemTypeParameter. */
    public static final ItemTypeParameter FUNCTION = fromString("function");

    /** Static value folder for ItemTypeParameter. */
    public static final ItemTypeParameter FOLDER = fromString("folder");

    /** Static value recent for ItemTypeParameter. */
    public static final ItemTypeParameter RECENT = fromString("recent");

    /**
     * Creates a new instance of ItemTypeParameter value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ItemTypeParameter() {
    }

    /**
     * Creates or finds a ItemTypeParameter from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ItemTypeParameter.
     */
    @JsonCreator
    public static ItemTypeParameter fromString(String name) {
        return fromString(name, ItemTypeParameter.class);
    }

    /**
     * Gets known ItemTypeParameter values.
     *
     * @return known ItemTypeParameter values.
     */
    public static Collection<ItemTypeParameter> values() {
        return values(ItemTypeParameter.class);
    }
}
