// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.applicationinsights.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Customer Managed Identity. */
@Fluent
public final class MyWorkbookManagedIdentity {
    /*
     * Customer Managed Identity
     */
    @JsonProperty(value = "userAssignedIdentities")
    private MyWorkbookUserAssignedIdentities userAssignedIdentities;

    /*
     * The identity type.
     */
    @JsonProperty(value = "type")
    private MyWorkbookManagedIdentityType type;

    /** Creates an instance of MyWorkbookManagedIdentity class. */
    public MyWorkbookManagedIdentity() {
    }

    /**
     * Get the userAssignedIdentities property: Customer Managed Identity.
     *
     * @return the userAssignedIdentities value.
     */
    public MyWorkbookUserAssignedIdentities userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: Customer Managed Identity.
     *
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the MyWorkbookManagedIdentity object itself.
     */
    public MyWorkbookManagedIdentity withUserAssignedIdentities(
        MyWorkbookUserAssignedIdentities userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Get the type property: The identity type.
     *
     * @return the type value.
     */
    public MyWorkbookManagedIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The identity type.
     *
     * @param type the type value to set.
     * @return the MyWorkbookManagedIdentity object itself.
     */
    public MyWorkbookManagedIdentity withType(MyWorkbookManagedIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (userAssignedIdentities() != null) {
            userAssignedIdentities().validate();
        }
    }
}
